/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology.tenodetunnelterminationcapability;

import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of terminationCapability.
 */
public class TerminationCapabilityKeys implements KeyInfo<DefaultTerminationCapability> {
    protected Object linkTp;
    /**
     * Returns the attribute linkTp.
     *
     * @return linkTp value of linkTp
     */
    public Object linkTp() {
        return linkTp;
    }

    /**
     * Sets the value to attribute linkTp.
     *
     * @param linkTp value of linkTp
     */
    public void linkTp(Object linkTp) {
        this.linkTp = linkTp;
    }


    @Override
    public int hashCode() {
        return Objects.hash(linkTp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TerminationCapabilityKeys) {
            TerminationCapabilityKeys other = (TerminationCapabilityKeys) obj;
            return
                Objects.equals(linkTp, other.linkTp);
        }
        return false;
    }
}