/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te.templates;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeTemplateName;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .templateattributes.ReferenceChangePolicyEnum;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconfigattributestemplate.TeNodeAttributes;

/**
 * Abstraction of an entity which represents the functionality of nodeTemplate.
 */
public interface NodeTemplate {

    /**
     * Identify the leaf of NodeTemplate.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents priority.
         */
        PRIORITY(2),
        /**
         * Represents referenceChangePolicy.
         */
        REFERENCECHANGEPOLICY(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    TeTemplateName name();

    /**
     * Returns the attribute priority.
     *
     * @return priority value of priority
     */
    int priority();

    /**
     * Returns the attribute referenceChangePolicy.
     *
     * @return referenceChangePolicy value of referenceChangePolicy
     */
    ReferenceChangePolicyEnum referenceChangePolicy();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute teNodeAttributes.
     *
     * @return teNodeAttributes value of teNodeAttributes
     */
    TeNodeAttributes teNodeAttributes();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(TeTemplateName name);

    /**
     * Sets the attribute priority.
     *
     * @param priority value of priority
     */
    void priority(int priority);

    /**
     * Sets the attribute referenceChangePolicy.
     *
     * @param referenceChangePolicy value of referenceChangePolicy
     */
    void referenceChangePolicy(ReferenceChangePolicyEnum referenceChangePolicy);

    /**
     * Sets the attribute teNodeAttributes.
     *
     * @param teNodeAttributes value of teNodeAttributes
     */
    void teNodeAttributes(TeNodeAttributes teNodeAttributes);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
