/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of bidirAssocCorouted.
 */
public abstract class BidirAssocCorouted extends BidirAssociationType {

    /**
     * Returns the attribute bidir-assoc-corouted.
     *
     * @return bidir-assoc-corouted value of bidir-assoc-corouted
     */
    public static String bidirAssocCoroutedToString() {
        return "bidir-assoc-corouted";
    }

    /**
     * Returns the object of bidirAssocCorouted fromString input String bidirAssocCorouted.
     *
     * @param valInString value of input String
     * @return bidirAssocCorouted
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bidir-assoc-corouted")) {
            return BidirAssocCorouted.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}