/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of pathTiebreakerRandoom.
 */
public abstract class PathTiebreakerRandoom extends PathTiebreakerType {

    /**
     * Returns the attribute path-tiebreaker-randoom.
     *
     * @return path-tiebreaker-randoom value of path-tiebreaker-randoom
     */
    public static String pathTiebreakerRandoomToString() {
        return "path-tiebreaker-randoom";
    }

    /**
     * Returns the object of pathTiebreakerRandoom fromString input String pathTiebreakerRandoom.
     *
     * @param valInString value of input String
     * @return pathTiebreakerRandoom
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("path-tiebreaker-randoom")) {
            return PathTiebreakerRandoom.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}