/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .explicitroutesubobject.type;

import com.google.common.base.MoreObjects;
import java.util.BitSet;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .explicitroutesubobject.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ipv6Address.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpv6Address extends InnerModelObject implements Ipv6Address {
    protected org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715
            .yrtietfinettypes.Ipv6Address v6Address;
    protected short v6PrefixLength;
    protected boolean v6Loose;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715
            .yrtietfinettypes.Ipv6Address v6Address() {
        return v6Address;
    }

    @Override
    public short v6PrefixLength() {
        return v6PrefixLength;
    }

    @Override
    public boolean v6Loose() {
        return v6Loose;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void v6Address(org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715
            .yrtietfinettypes.Ipv6Address v6Address) {
        valueLeafFlags.set(LeafIdentifier.V6ADDRESS.getLeafIndex());
        this.v6Address = v6Address;
    }

    @Override
    public void v6PrefixLength(short v6PrefixLength) {
        valueLeafFlags.set(LeafIdentifier.V6PREFIXLENGTH.getLeafIndex());
        this.v6PrefixLength = v6PrefixLength;
    }

    @Override
    public void v6Loose(boolean v6Loose) {
        valueLeafFlags.set(LeafIdentifier.V6LOOSE.getLeafIndex());
        this.v6Loose = v6Loose;
    }

    @Override
    public int hashCode() {
        return Objects.hash(v6Address, v6PrefixLength, v6Loose, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv6Address) {
            DefaultIpv6Address other = (DefaultIpv6Address) obj;
            return
                Objects.equals(v6Address, other.v6Address) &&
                Objects.equals(v6PrefixLength, other.v6PrefixLength) &&
                Objects.equals(v6Loose, other.v6Loose) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("v6Address", v6Address)
            .add("v6PrefixLength", v6PrefixLength)
            .add("v6Loose", v6Loose)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultIpv6Address.
     */
    public DefaultIpv6Address() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
