/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks.chips;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of coldDrink.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultColdDrink extends InnerModelObject implements ColdDrink {
    protected List<String> flavor;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<String> flavor() {
        return flavor;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void flavor(List<String> flavor) {
        valueLeafFlags.set(LeafIdentifier.FLAVOR.getLeafIndex());
        this.flavor = flavor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(flavor, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultColdDrink) {
            DefaultColdDrink other = (DefaultColdDrink) obj;
            return
                Objects.equals(flavor, other.flavor) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("flavor", flavor)
            .add("valueLeafFlags", valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultColdDrink.
     */
    public DefaultColdDrink() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
