/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.helperutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.model.DefaultYangModel;
import org.onosproject.yang.model.DefaultYangModule;
import org.onosproject.yang.model.DefaultYangModuleId;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangApacheUtils {
    public static final String SLASH = File.separator;
    public static final String HYPHEN = "-";
    public static final String PERIOD = ".";
    public static final String YANG_META_DATA = "YangMetaData.ser";
    public static final String YANG_RESOURCES = "yang/resources";
    private static final String SYSTEM = SLASH + "system" + SLASH;
    private static final String MAVEN = "mvn:";
    private static final String JAR = ".jar";
    private static final String USER_DIRECTORY = "user.dir";
    private static final String DATE_FORMAT = "yyyy-mm-dd";
    private static final String ONOS = "org.onosproject";
    private static final Logger log = LoggerFactory.getLogger(YangApacheUtils.class);

    private YangApacheUtils() {
    }

    public static YangModel getYangModel(Class<?> modClass) {
        BundleContext context = FrameworkUtil.getBundle(modClass).getBundleContext();
        if (context != null) {
            Bundle[] bundles = context.getBundles();
            int len = bundles.length;
            for (int i = len - 1; i >= 0; --i) {
                Bundle bundle = bundles[i];
                if (!bundle.getSymbolicName().contains(ONOS)) continue;
                String jarPath = YangApacheUtils.getJarPathFromBundleLocation(bundle.getLocation(), context.getProperty(USER_DIRECTORY));
                String metaPath = jarPath + SLASH + YANG_RESOURCES + SLASH + YANG_META_DATA;
                List<YangNode> curNodes = YangApacheUtils.processJarParsingOperations(jarPath);
                if (curNodes == null || curNodes.isEmpty()) continue;
                return YangApacheUtils.processYangModel(metaPath, curNodes);
            }
        }
        return null;
    }

    public static YangModel processYangModel(String path, List<YangNode> curNodes) {
        DefaultYangModel model = new DefaultYangModel();
        for (YangSchemaNode yangSchemaNode : curNodes) {
            YangModuleId id = YangApacheUtils.processModuleId((YangNode)yangSchemaNode);
            DefaultYangModule module = new DefaultYangModule(id, Paths.get(yangSchemaNode.getFileName(), new String[0]), Paths.get(path, new String[0]));
            model.addModule(id, (YangModule)module);
        }
        return model;
    }

    public static YangModuleId processModuleId(YangNode module) {
        String rev = YangApacheUtils.getDateInStringFormat(module);
        return new DefaultYangModuleId(module.getName(), rev);
    }

    public static String getDateInStringFormat(YangNode schemaNode) {
        if (schemaNode != null && schemaNode.getRevision() != null) {
            return new SimpleDateFormat(DATE_FORMAT).format(schemaNode.getRevision().getRevDate());
        }
        return null;
    }

    private static String getJarPathFromBundleLocation(String mvnLocationPath, String currentDirectory) {
        String[] split;
        String[] strArray;
        String path = currentDirectory + SYSTEM;
        if (mvnLocationPath.contains(MAVEN) && (strArray = mvnLocationPath.split(MAVEN))[1].contains(File.separator) && (split = strArray[1].split(File.separator))[0].contains(PERIOD)) {
            String[] groupId = split[0].split(Pattern.quote(PERIOD));
            return path + groupId[0] + SLASH + groupId[1] + SLASH + split[1] + SLASH + split[2] + SLASH + split[1] + HYPHEN + split[2];
        }
        return null;
    }

    private static List<YangNode> processJarParsingOperations(String path) {
        String jar = path + JAR;
        try {
            File file = new File(jar);
            if (file.exists()) {
                return DataModelUtils.parseJarFile(path + JAR, path);
            }
        }
        catch (IOException e) {
            log.error(" failed to parse the jar file in path {} : {} ", (Object)path, (Object)e.getMessage());
        }
        return null;
    }
}

