/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network3.rev20151208;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network3.rev20151208.ietfnetwork3.Networks;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ietfNetwork3.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class IetfNetwork3OpParam extends InnerModelObject implements IetfNetwork3 {
    protected Networks networks;

    @Override
    public Networks networks() {
        return networks;
    }

    @Override
    public void networks(Networks networks) {
        this.networks = networks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(networks);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IetfNetwork3OpParam) {
            IetfNetwork3OpParam other = (IetfNetwork3OpParam) obj;
            return
                Objects.equals(networks, other.networks);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("networks", networks)
            .toString();
    }

    /**
     * Creates an instance of ietfNetwork3OpParam.
     */
    public IetfNetwork3OpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}
