/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networksstate;

import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of network.
 */
public class NetworkKeys implements KeyInfo<DefaultNetwork> {
    protected Object networkRef;
    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    public Object networkRef() {
        return networkRef;
    }

    /**
     * Sets the value to attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    public void networkRef(Object networkRef) {
        this.networkRef = networkRef;
    }


    @Override
    public int hashCode() {
        return Objects.hash(networkRef);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NetworkKeys) {
            NetworkKeys other = (NetworkKeys) obj;
            return
                Objects.equals(networkRef, other.networkRef);
        }
        return false;
    }
}