/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .networks.network;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologyaugment.Te;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedNwNetwork.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedNwNetwork extends InnerModelObject implements AugmentedNwNetwork {
    protected Te te;

    @Override
    public Te te() {
        return te;
    }

    @Override
    public void te(Te te) {
        this.te = te;
    }

    @Override
    public int hashCode() {
        return Objects.hash(te);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedNwNetwork) {
            DefaultAugmentedNwNetwork other = (DefaultAugmentedNwNetwork) obj;
            return
                Objects.equals(te, other.te);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("te", te)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedNwNetwork.
     */
    public DefaultAugmentedNwNetwork() {
    }

}
