/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkaugment.te;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkconfig.BundleStackLevel;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkconfigattributes.TeLinkAttributes;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected List<Object> teLinkTemplate;
    protected BitSet valueLeafFlags = new BitSet();
    protected BundleStackLevel bundleStackLevel;
    protected TeLinkAttributes teLinkAttributes;

    @Override
    public List<Object> teLinkTemplate() {
        return teLinkTemplate;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public BundleStackLevel bundleStackLevel() {
        return bundleStackLevel;
    }

    @Override
    public TeLinkAttributes teLinkAttributes() {
        return teLinkAttributes;
    }

    @Override
    public void teLinkTemplate(List<Object> teLinkTemplate) {
        valueLeafFlags.set(LeafIdentifier.TELINKTEMPLATE.getLeafIndex());
        this.teLinkTemplate = teLinkTemplate;
    }

    @Override
    public void bundleStackLevel(BundleStackLevel bundleStackLevel) {
        this.bundleStackLevel = bundleStackLevel;
    }

    @Override
    public void teLinkAttributes(TeLinkAttributes teLinkAttributes) {
        this.teLinkAttributes = teLinkAttributes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(teLinkTemplate, valueLeafFlags, bundleStackLevel, teLinkAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.equals(teLinkTemplate, other.teLinkTemplate) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(bundleStackLevel, other.bundleStackLevel) &&
                Objects.equals(teLinkAttributes, other.teLinkAttributes);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("teLinkTemplate", teLinkTemplate)
            .add("valueLeafFlags", valueLeafFlags)
            .add("bundleStackLevel", bundleStackLevel)
            .add("teLinkAttributes", teLinkAttributes)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
