/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.InterfaceAdjustmentCapability;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.MaxLspBandwidth;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkinfoattributes.interfaceswitchingcapability.TimeDivisionMultiplexCapable;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .LspEncodingTypes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .SwitchingCapabilities;

/**
 * Abstraction of an entity which represents the functionality of interfaceSwitchingCapability.
 */
public interface InterfaceSwitchingCapability {

    /**
     * Identify the leaf of InterfaceSwitchingCapability.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents switchingCapability.
         */
        SWITCHINGCAPABILITY(1),
        /**
         * Represents encoding.
         */
        ENCODING(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute switchingCapability.
     *
     * @return switchingCapability value of switchingCapability
     */
    Class<? extends SwitchingCapabilities> switchingCapability();

    /**
     * Returns the attribute encoding.
     *
     * @return encoding value of encoding
     */
    Class<? extends LspEncodingTypes> encoding();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute maxLspBandwidth.
     *
     * @return maxLspBandwidth list of maxLspBandwidth
     */
    List<MaxLspBandwidth> maxLspBandwidth();

    /**
     * Returns the attribute timeDivisionMultiplexCapable.
     *
     * @return timeDivisionMultiplexCapable value of timeDivisionMultiplexCapable
     */
    TimeDivisionMultiplexCapable timeDivisionMultiplexCapable();

    /**
     * Returns the attribute interfaceAdjustmentCapability.
     *
     * @return interfaceAdjustmentCapability list of interfaceAdjustmentCapability
     */
    List<InterfaceAdjustmentCapability> interfaceAdjustmentCapability();

    /**
     * Sets the attribute switchingCapability.
     *
     * @param switchingCapability value of switchingCapability
     */
    void switchingCapability(Class<? extends SwitchingCapabilities> switchingCapability);

    /**
     * Sets the attribute encoding.
     *
     * @param encoding value of encoding
     */
    void encoding(Class<? extends LspEncodingTypes> encoding);

    /**
     * Sets the attribute maxLspBandwidth.
     *
     * @param maxLspBandwidth list of maxLspBandwidth
     */
    void maxLspBandwidth(List<MaxLspBandwidth> maxLspBandwidth);

    /**
     * Sets the attribute timeDivisionMultiplexCapable.
     *
     * @param timeDivisionMultiplexCapable value of timeDivisionMultiplexCapable
     */
    void timeDivisionMultiplexCapable(TimeDivisionMultiplexCapable timeDivisionMultiplexCapable);

    /**
     * Sets the attribute interfaceAdjustmentCapability.
     *
     * @param interfaceAdjustmentCapability list of interfaceAdjustmentCapability
     */
    void interfaceAdjustmentCapability(List<InterfaceAdjustmentCapability> interfaceAdjustmentCapability);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
