/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes.underlaybackuppath.PathElement;

/**
 * Abstraction of an entity which represents the functionality of underlayBackupPath.
 */
public interface UnderlayBackupPath {

    /**
     * Identify the leaf of UnderlayBackupPath.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents index.
         */
        INDEX(1),
        /**
         * Represents providerIdRef.
         */
        PROVIDERIDREF(2),
        /**
         * Represents clientIdRef.
         */
        CLIENTIDREF(3),
        /**
         * Represents teTopologyIdRef.
         */
        TETOPOLOGYIDREF(4),
        /**
         * Represents networkIdRef.
         */
        NETWORKIDREF(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute index.
     *
     * @return index value of index
     */
    long index();

    /**
     * Returns the attribute providerIdRef.
     *
     * @return providerIdRef value of providerIdRef
     */
    Object providerIdRef();

    /**
     * Returns the attribute clientIdRef.
     *
     * @return clientIdRef value of clientIdRef
     */
    Object clientIdRef();

    /**
     * Returns the attribute teTopologyIdRef.
     *
     * @return teTopologyIdRef value of teTopologyIdRef
     */
    Object teTopologyIdRef();

    /**
     * Returns the attribute networkIdRef.
     *
     * @return networkIdRef value of networkIdRef
     */
    Object networkIdRef();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute pathElement.
     *
     * @return pathElement list of pathElement
     */
    List<PathElement> pathElement();

    /**
     * Sets the attribute index.
     *
     * @param index value of index
     */
    void index(long index);

    /**
     * Sets the attribute providerIdRef.
     *
     * @param providerIdRef value of providerIdRef
     */
    void providerIdRef(Object providerIdRef);

    /**
     * Sets the attribute clientIdRef.
     *
     * @param clientIdRef value of clientIdRef
     */
    void clientIdRef(Object clientIdRef);

    /**
     * Sets the attribute teTopologyIdRef.
     *
     * @param teTopologyIdRef value of teTopologyIdRef
     */
    void teTopologyIdRef(Object teTopologyIdRef);

    /**
     * Sets the attribute networkIdRef.
     *
     * @param networkIdRef value of networkIdRef
     */
    void networkIdRef(Object networkIdRef);

    /**
     * Sets the attribute pathElement.
     *
     * @param pathElement list of pathElement
     */
    void pathElement(List<PathElement> pathElement);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
