/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .Snacks;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks.chips.Banana;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .snacks.chips.ColdDrink;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of chips.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultChips extends InnerModelObject implements Chips {
    protected List<Boolean> potato;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<Banana> banana;
    protected ColdDrink coldDrink;

    @Override
    public List<Boolean> potato() {
        return potato;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<Banana> banana() {
        return banana;
    }

    @Override
    public ColdDrink coldDrink() {
        return coldDrink;
    }

    @Override
    public void potato(List<Boolean> potato) {
        valueLeafFlags.set(LeafIdentifier.POTATO.getLeafIndex());
        this.potato = potato;
    }

    @Override
    public void banana(List<Banana> banana) {
        this.banana = banana;
    }

    @Override
    public void coldDrink(ColdDrink coldDrink) {
        this.coldDrink = coldDrink;
    }

    @Override
    public int hashCode() {
        return Objects.hash(potato, valueLeafFlags, banana, coldDrink);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultChips) {
            DefaultChips other = (DefaultChips) obj;
            return
                Objects.equals(potato, other.potato) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(banana, other.banana) &&
                Objects.equals(coldDrink, other.coldDrink);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(getClass())
            .omitNullValues()
            .add("potato", potato)
            .add("valueLeafFlags", valueLeafFlags)
            .add("banana", banana)
            .add("coldDrink", coldDrink)
            .toString();
    }


    /**
     * Creates an instance of defaultChips.
     */
    public DefaultChips() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
