/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import java.util.List;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class AugmentListener {
    private AugmentListener() {
    }

    public static void processAugmentEntry(TreeWalkListener listener, GeneratedYangParser.AugmentStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangUses) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY));
        }
        if (!(curData instanceof YangModule) && !(curData instanceof YangSubModule)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY));
        }
        List<YangAtomicPath> atomics = ListenerUtil.getValidAbsoluteSchemaNodeId(ctx.augment().getText(), YangConstructType.AUGMENT_DATA, ctx);
        AugmentListener.valSubStatCardinality(ctx);
        int line = ctx.getStart().getLine();
        int pos = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, pos, "", YangConstructType.AUGMENT_DATA);
        YangNode root = (YangNode)((Object)curData);
        String name = ListenerUtil.getPrefixRemovedName(atomics, root);
        YangAugment augment = YangDataModelFactory.getYangAugmentNode(GeneratedLanguage.JAVA_GENERATION);
        augment.setLineNumber(line);
        augment.setCharPosition(pos);
        augment.setFileName(listener.getFileName());
        augment.setTargetNode(atomics);
        augment.setName(ListenerUtil.removeQuotesAndHandleConcat(ctx.augment().getText()));
        augment.setPrefixRemovedName(name);
        try {
            root.addChild(augment);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
        }
        listener.getParsedDataStack().push(augment);
        YangResolutionInfoImpl<YangAugment> info = new YangResolutionInfoImpl<YangAugment>(augment, root, line, pos);
        AugmentListener.addToResolution(info, ctx);
    }

    public static void processAugmentExit(TreeWalkListener listener, GeneratedYangParser.AugmentStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangAugment)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void valSubStatCardinality(GeneratedYangParser.AugmentStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.whenStatement(), YangConstructType.WHEN_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityEitherOne(ctx.dataDefStatement(), YangConstructType.DATA_DEF_DATA, ctx.caseStatement(), YangConstructType.CASE_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ctx);
    }

    private static void addToResolution(YangResolutionInfoImpl<YangAugment> info, GeneratedYangParser.AugmentStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(info);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
        }
    }
}

