/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangDecimal64;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.RestrictionResolver;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypeUtils;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class RangeRestrictionListener {
    private RangeRestrictionListener() {
    }

    public static void processRangeRestrictionEntry(TreeWalkListener listener, GeneratedYangParser.RangeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        RangeRestrictionListener.setRangeRestriction(listener, type, ctx);
    }

    private static void setRangeRestriction(TreeWalkListener listener, YangType type, GeneratedYangParser.RangeStatementContext ctx) {
        if (type.getDataType() == YangDataTypes.DERIVED) {
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setRangeRestrictionString(ctx.range().getText());
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setLineNumber(ctx.getStart().getLine());
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setCharPosition(ctx.getStart().getCharPositionInLine());
            return;
        }
        if (!YangDataTypeUtils.isOfRangeRestrictedType(type.getDataType()) && type.getDataType() != YangDataTypes.DECIMAL64) {
            ParserException parserException = new ParserException("YANG file error: Range restriction can't be applied to a given type");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        YangRangeRestriction rangeRestriction = null;
        try {
            if (type.getDataType() == YangDataTypes.DECIMAL64) {
                YangDecimal64 yangDecimal64 = (YangDecimal64)type.getDataTypeExtendedInfo();
                rangeRestriction = RestrictionResolver.processRangeRestriction(yangDecimal64.getDefaultRangeRestriction(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), true, ctx.range().getText(), type.getDataType(), listener.getFileName());
            } else {
                rangeRestriction = RestrictionResolver.processRangeRestriction(null, ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine(), false, ctx.range().getText(), type.getDataType(), listener.getFileName());
            }
        }
        catch (DataModelException e) {
            ParserException parserException = new ParserException(e.getMessage());
            parserException.setCharPosition(e.getCharPositionInLine());
            parserException.setLine(e.getLineNumber());
            throw parserException;
        }
        if (rangeRestriction != null) {
            if (type.getDataType() == YangDataTypes.DECIMAL64) {
                ((YangDecimal64)type.getDataTypeExtendedInfo()).setRangeRestrictedExtendedInfo(rangeRestriction);
            } else {
                type.setDataTypeExtendedInfo(rangeRestriction);
            }
        }
        listener.getParsedDataStack().push(rangeRestriction);
    }

    public static void processRangeRestrictionExit(TreeWalkListener listener, GeneratedYangParser.RangeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData instanceof YangRangeRestriction) {
            listener.getParsedDataStack().pop();
        } else if (!(tmpData instanceof YangType) || ((YangType)tmpData).getDataType() != YangDataTypes.DERIVED) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

