/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.tool.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.onosproject.yang.compiler.api.YangCompilationParam;
import org.onosproject.yang.compiler.api.YangCompiledOutput;
import org.onosproject.yang.compiler.api.YangCompilerException;
import org.onosproject.yang.compiler.api.YangCompilerService;
import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.YangDeviationHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.linker.YangLinker;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.linker.impl.YangLinkerManager;
import org.onosproject.yang.compiler.linker.impl.YangLinkerUtils;
import org.onosproject.yang.compiler.parser.YangUtilsParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.YangUtilsParserManager;
import org.onosproject.yang.compiler.tool.YangFileInfo;
import org.onosproject.yang.compiler.tool.impl.DefaultYangCompiledOutput;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorUtil;
import org.onosproject.yang.compiler.utils.UtilConstants;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.YangFileScanner;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.DefaultYangModel;
import org.onosproject.yang.model.DefaultYangModule;
import org.onosproject.yang.model.DefaultYangModuleId;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangCompilerManager
implements YangCompilerService {
    private static final Logger log = LoggerFactory.getLogger(YangCompilerManager.class);
    private static final String DATE_FORMAT = "yyyy-mm-dd";
    private final YangUtilsParser yangUtilsParser = new YangUtilsParserManager();
    private final YangLinker yangLinker = new YangLinkerManager();
    private final Set<YangNode> yangNodeSet = new HashSet<YangNode>();
    private Set<YangFileInfo> yangFileInfoSet;
    private YangFileInfo curYangFileInfo = new YangFileInfo();
    private Set<Path> genJavaPath = new LinkedHashSet<Path>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YangCompiledOutput compileYangFiles(YangCompilationParam param) throws IOException, YangCompilerException {
        Class<YangCompilerManager> clazz = YangCompilerManager.class;
        synchronized (YangCompilerManager.class) {
            YangPluginConfig config = new YangPluginConfig();
            config.setCodeGenDir(param.getCodeGenDir().toString() + UtilConstants.SLASH);
            config.resourceGenDir(param.getMetadataGenDir().toString() + UtilConstants.SLASH);
            this.processYangFiles(this.createYangFileInfoSet(param.getYangFiles()), this.dependentSchema(param.getDependentSchemas()), config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new DefaultYangCompiledOutput(this.processYangModel(config.resourceGenDir()), this.genJavaPath);
        }
    }

    private YangModel processYangModel(String path) {
        DefaultYangModel model = new DefaultYangModel();
        for (YangNode node : this.yangNodeSet) {
            YangModuleId id = this.processModuleId(node);
            DefaultYangModule module = new DefaultYangModule(id, Paths.get(node.getFileName(), new String[0]), Paths.get(path, new String[0]));
            model.addModule(id, (YangModule)module);
        }
        return model;
    }

    private YangModuleId processModuleId(YangNode module) {
        String rev = this.getDateInStringFormat(module);
        return new DefaultYangModuleId(module.getName(), rev);
    }

    private String getDateInStringFormat(YangNode schemaNode) {
        if (schemaNode != null && schemaNode.getRevision() != null) {
            return new SimpleDateFormat(DATE_FORMAT).format(schemaNode.getRevision().getRevDate());
        }
        return null;
    }

    public Set<YangNode> getYangNodeSet() {
        return this.yangNodeSet;
    }

    private static List<File> getListOfFile(Set<YangFileInfo> yangFileInfo) {
        ArrayList<File> files = new ArrayList<File>();
        for (YangFileInfo yangFile : yangFileInfo) {
            if (!yangFile.isForTranslator()) continue;
            files.add(new File(yangFile.getYangFileName()));
        }
        return files;
    }

    public Set<YangFileInfo> createYangFileInfoSet(Set<Path> yangFileList) {
        if (this.yangFileInfoSet == null) {
            this.yangFileInfoSet = new HashSet<YangFileInfo>();
        }
        for (Path yangFile : yangFileList) {
            YangFileInfo yangFileInfo = new YangFileInfo();
            yangFileInfo.setYangFileName(yangFile.toString());
            this.yangFileInfoSet.add(yangFileInfo);
        }
        return this.yangFileInfoSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processYangFiles(Set<YangFileInfo> yangFiles, Set<YangNode> dependentSchema, YangPluginConfig config) throws IOException {
        Class<YangCompilerManager> clazz = YangCompilerManager.class;
        synchronized (YangCompilerManager.class) {
            try {
                this.yangFileInfoSet = yangFiles;
                if (this.yangFileInfoSet.isEmpty()) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                YangIoUtils.createDirectories(config.resourceGenDir());
                this.addSchemaToFileSet(dependentSchema);
                this.parseYangFileInfoSet();
                this.resolveDependenciesUsingLinker();
                this.translateToJava(config);
                this.processGeneratedCode(config.getCodeGenDir());
                this.processSerialization(config.resourceGenDir());
                this.processCopyYangFile(config.resourceGenDir());
            }
            catch (IOException | ParserException e) {
                YangCompilerException exception = new YangCompilerException(e.getMessage(), (Throwable)e);
                exception.setYangFile(Paths.get(this.curYangFileInfo.getYangFileName(), new String[0]));
                if (this.curYangFileInfo != null && this.curYangFileInfo.getRootNode() != null) {
                    try {
                        JavaCodeGeneratorUtil.translatorErrorHandler(this.curYangFileInfo.getRootNode(), config);
                    }
                    catch (IOException ex) {
                        e.printStackTrace();
                        throw ex;
                    }
                }
                throw exception;
            }
            return;
        }
    }

    private void processGeneratedCode(String codeGenDir) throws IOException {
        List<String> files = YangFileScanner.getJavaFiles(codeGenDir);
        for (String file : files) {
            this.genJavaPath.add(Paths.get(file, new String[0]));
        }
    }

    private Set<YangNode> dependentSchema(Set<Path> dependentSchemaPath) {
        LinkedHashSet<YangNode> depNodes = new LinkedHashSet<YangNode>();
        for (Path path : dependentSchemaPath) {
            try {
                depNodes.addAll(DataModelUtils.deSerializeDataModel(path.toString()));
            }
            catch (IOException e) {
                throw new YangCompilerException("Failed to fetch dependent schema from given path :" + path.toString());
            }
        }
        return depNodes;
    }

    private void addSchemaToFileSet(Set<YangNode> dependentSchema) throws IOException {
        if (dependentSchema == null || dependentSchema.isEmpty()) {
            return;
        }
        for (YangNode node : dependentSchema) {
            YangFileInfo dependentFileInfo = new YangFileInfo();
            node.setToTranslate(false);
            dependentFileInfo.setRootNode(node);
            dependentFileInfo.setForTranslator(false);
            dependentFileInfo.setYangFileName(node.getName());
            this.yangFileInfoSet.add(dependentFileInfo);
        }
    }

    public void resolveDependenciesUsingLinker() {
        this.createYangNodeSet();
        try {
            this.yangLinker.resolveDependencies(this.yangNodeSet);
        }
        catch (LinkerException e) {
            this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
            throw new YangCompilerException(e.getMessage());
        }
    }

    public void createYangNodeSet() {
        for (YangFileInfo yangFileInfo : this.yangFileInfoSet) {
            this.yangNodeSet.add(yangFileInfo.getRootNode());
        }
    }

    public void parseYangFileInfoSet() throws IOException {
        Iterator<YangFileInfo> iterator = this.yangFileInfoSet.iterator();
        while (iterator.hasNext()) {
            YangFileInfo yangFileInfo;
            this.curYangFileInfo = yangFileInfo = iterator.next();
            if (!yangFileInfo.isForTranslator()) continue;
            try {
                YangNode yangNode = this.yangUtilsParser.getDataModel(yangFileInfo.getYangFileName());
                yangFileInfo.setRootNode(yangNode);
                YangLinkerUtils.resolveGroupingInDefinationScope((YangReferenceResolver)((Object)yangNode));
                try {
                    ((YangReferenceResolver)((Object)yangNode)).resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
                    ((YangReferenceResolver)((Object)yangNode)).resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
                }
                catch (DataModelException e) {
                    this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
                }
            }
            catch (ParserException e) {
                this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
                throw e;
            }
        }
    }

    public void translateToJava(YangPluginConfig pluginConfig) throws IOException {
        LinkedList<YangNode> yangNodeSortedList = new LinkedList<YangNode>();
        yangNodeSortedList.addAll(this.yangNodeSet);
        Collections.sort(yangNodeSortedList);
        for (YangNode node : yangNodeSortedList) {
            if (!node.isToTranslate() || ((YangDeviationHolder)((Object)node)).isModuleForDeviation()) continue;
            JavaCodeGeneratorUtil.generateJavaCode(node, pluginConfig);
        }
    }

    private void printLog(String fileName, int line, int position, String msg, String localMsg) {
        String logInfo = "Error in file: " + fileName;
        if (line != 0) {
            logInfo = logInfo + " at line: " + line + " at position: " + position;
        }
        if (msg != null) {
            logInfo = logInfo + "\n" + localMsg;
        }
        log.info(logInfo);
    }

    private void processSerialization(String path) throws IOException {
        HashSet<YangNode> compiledSchemas = new HashSet<YangNode>();
        for (YangFileInfo fileInfo : this.yangFileInfoSet) {
            compiledSchemas.add(fileInfo.getRootNode());
        }
        String serFileName = path + "YangMetaData.ser";
        FileOutputStream fileOutputStream = new FileOutputStream(serFileName);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(compiledSchemas);
        objectOutputStream.close();
        fileOutputStream.close();
    }

    private void processCopyYangFile(String path) throws IOException {
        boolean isCreated;
        List<File> files = YangCompilerManager.getListOfFile(this.yangFileInfoSet);
        File targetDir = new File(path);
        if (!targetDir.exists() && !(isCreated = targetDir.mkdirs())) {
            throw new YangCompilerException("failed to create yang resource directory.");
        }
        for (File file : files) {
            Files.copy(file.toPath(), new File(path + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public Set<YangFileInfo> getYangFileInfoSet() {
        return this.yangFileInfoSet;
    }

    public void setYangFileInfoSet(Set<YangFileInfo> yangFileInfoSet) {
        this.yangFileInfoSet = yangFileInfoSet;
    }
}

