/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaImportData;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodClassTypes;
import org.onosproject.yang.compiler.translator.tojava.utils.StringGenerator;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public class TempJavaRpcCommandFragmentFiles
extends TempJavaFragmentFiles {
    private File rpcCommandClassTempFileHandle;
    private static final String VAR_RPC_INPUT = "rpcInput";
    private static final String VAR_INPUT = "input";
    private static final String VAR_OUTPUT = "output";
    private static final String VAR_MSG_ID = "msgId";
    private static final String VAR_STORE = "store";
    private static final String VAR_STORE_SERVICE = "storeService";
    private static final String VAR_MODEL_CONVERTER = "modelConverter";
    private static final String EXECUTE = "execute";
    private static final String GET_RESOURCE_ID = "getResourceId";
    private static final String VAR_INPUT_OBJECT = "inputObject";
    private static final String VAR_OUTPUT_OBJECT = "outputObject";
    private static final String RPC_RESPONSE = "rpcResponse";
    private static final String VAR_DATA_NODE = "dataNode";

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) {
        YangNode outputNode;
        JavaImportData importData = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getRpcCommandTempFiles().getJavaImportData();
        String parentPkg = curNode.getParent().getJavaPackage();
        String parentClassName = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(curNode.getParent().getJavaClassNameOrBuiltInType(), null));
        String className = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(curNode.getJavaClassNameOrBuiltInType(), null) + "Command");
        YangNode inputNode = DataModelUtils.findRpcInput(curNode);
        if (inputNode != null) {
            JavaQualifiedTypeInfoTranslator inputImport = new JavaQualifiedTypeInfoTranslator();
            inputImport.setForInterface(false);
            inputImport.setPkgInfo(inputNode.getJavaPackage());
            inputImport.setClassInfo(YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(inputNode.getJavaClassNameOrBuiltInType(), null)));
            importData.addImportInfo(inputImport, className, curNode.getJavaPackage());
        }
        if ((outputNode = DataModelUtils.findRpcOutput(curNode)) != null) {
            JavaQualifiedTypeInfoTranslator outputImport = new JavaQualifiedTypeInfoTranslator();
            outputImport.setForInterface(false);
            outputImport.setPkgInfo(outputNode.getJavaPackage());
            outputImport.setClassInfo(YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(outputNode.getJavaClassNameOrBuiltInType(), null)));
            importData.addImportInfo(outputImport, className, curNode.getJavaPackage());
            JavaQualifiedTypeInfoTranslator defaultOutput = new JavaQualifiedTypeInfoTranslator();
            defaultOutput.setForInterface(false);
            defaultOutput.setPkgInfo(outputNode.getJavaPackage());
            defaultOutput.setClassInfo("Default" + YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(outputNode.getJavaClassNameOrBuiltInType(), null)));
            importData.addImportInfo(defaultOutput, className, curNode.getJavaPackage());
        }
        JavaQualifiedTypeInfoTranslator importInfo = new JavaQualifiedTypeInfoTranslator();
        importInfo.setForInterface(false);
        importInfo.setPkgInfo(parentPkg);
        importInfo.setClassInfo(parentClassName + "Service");
        importData.addImportInfo(importInfo, className, curNode.getJavaPackage());
        JavaQualifiedTypeInfoTranslator extendedCmdImport = new JavaQualifiedTypeInfoTranslator();
        extendedCmdImport.setForInterface(false);
        extendedCmdImport.setPkgInfo(parentPkg);
        extendedCmdImport.setClassInfo("RpcExtendedCommand");
        importData.addImportInfo(extendedCmdImport, className, curNode.getJavaPackage());
        List<String> imports = importData.getImports(false);
        imports.add(importData.getImportForModelConverter());
        imports.add(importData.getImportForResourceId());
        imports.add(importData.getImportForRpcInput());
        imports.add(importData.getImportForRpcOutput());
        imports.add(importData.getImportForDynamicStoreService());
        imports.add(importData.getImportForDataNode());
        imports.add(importData.getImportForRpcSuccess());
        try {
            this.rpcCommandClassTempFileHandle = this.getJavaFileHandle(className);
            JavaFileGenerator.generateRpcCommand(this.rpcCommandClassTempFileHandle, curNode, imports);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to generate code for RPC command" + curNode.getName());
        }
    }

    TempJavaRpcCommandFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        super(javaFileInfo);
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        super.freeTemporaryResources(isErrorOccurred);
    }

    public static String getRpcCommandContents(YangNode node) {
        String appService = node.getParent().getJavaClassNameOrBuiltInType() + "Service";
        String className = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(node.getJavaClassNameOrBuiltInType(), null)) + "Command";
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(VAR_STORE, "DynamicConfigService");
        param.put(VAR_MODEL_CONVERTER, "ModelConverter");
        param.put(appService, YangIoUtils.getCapitalCase(appService));
        StringBuilder builder = new StringBuilder();
        builder.append(StringGenerator.getVariableDeclaration(VAR_MODEL_CONVERTER, "ModelConverter", "    ", "private")).append(StringGenerator.getVariableDeclaration(appService, YangIoUtils.getCapitalCase(appService), "    ", "private")).append(StringGenerator.getVariableDeclaration(VAR_STORE_SERVICE, "DynamicConfigService", "    ", "private")).append("\n").append(JavaDocGen.getJavaDocForRpcCommandConstructor(node.getJavaClassNameOrBuiltInType())).append("\n").append(StringGenerator.multiAttrMethodSignature(className, null, "public", null, param, MethodClassTypes.CLASS_TYPE, "    ")).append("        ").append("super").append("(").append(GET_RESOURCE_ID).append("(").append(")").append(")").append(";").append("\n").append(StringGenerator.valueAssign("this.storeService", VAR_STORE, "        ")).append(StringGenerator.valueAssign("this.modelConverter", VAR_MODEL_CONVERTER, "        ")).append(StringGenerator.valueAssign("this." + appService, appService, "        ")).append("    ").append("}").append("\n").append(TempJavaRpcCommandFragmentFiles.getRpcCommandExecuteMethod(appService, node)).append(TempJavaRpcCommandFragmentFiles.getResourceIdMethod(node));
        return builder.toString();
    }

    private static String getRpcCommandExecuteMethod(String appService, YangNode node) {
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString()).append("    ").append("public").append(" ").append("void").append(" ").append(EXECUTE).append("(").append("RpcInput").append(" ").append(VAR_RPC_INPUT).append(")").append(" ").append("{").append("\n").append("    ").append("}").append("\n").append("\n").append(JavaDocGen.getJavaDocForExecuteMethod()).append("\n").append("    ").append("public").append(" ").append("void").append(" ").append(EXECUTE).append("(").append("RpcInput").append(" ").append(VAR_RPC_INPUT).append(",").append(" ").append("int").append(" ").append(VAR_MSG_ID).append(")").append(" ").append("{").append("\n").append(TempJavaRpcCommandFragmentFiles.getExecuteMethodContents(node, appService)).append("    ").append("}").append("\n");
        return builder.toString();
    }

    private static String getResourceIdMethod(YangNode node) {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("    ").append("private").append(" ").append("static").append(" ").append("ResourceId").append(" ").append(GET_RESOURCE_ID).append("(").append(")").append(" ").append("{").append("\n").append("        ").append("return").append(" ").append("new").append(" ").append("ResourceId").append(".").append("Builder").append("(").append(")").append(".").append("addBranchPointSchema").append("(").append("\"").append("/").append("\"").append(",").append(" ").append("null").append(")").append("\n").append("                ").append(".").append("addBranchPointSchema").append("(").append("\"").append(node.getName()).append("\"").append(",").append(" ").append("\"").append(node.getParent().getNameSpace().getModuleNamespace()).append("\"").append(")").append(".").append("build").append("(").append(")").append(";").append("\n").append("    ").append("}").append("\n");
        return builder.toString();
    }

    private static String getExecuteMethodContents(YangNode node, String appService) {
        StringBuilder builder = new StringBuilder();
        builder.append(TempJavaRpcCommandFragmentFiles.invokeCreateModelString(node)).append(TempJavaRpcCommandFragmentFiles.invokeRpcString(node, appService)).append(TempJavaRpcCommandFragmentFiles.invokeCreateDataNodeString(node)).append(TempJavaRpcCommandFragmentFiles.createRpcOutputString(node)).append(TempJavaRpcCommandFragmentFiles.invokeRpcResponseString());
        return builder.toString();
    }

    private static String invokeCreateModelString(YangNode node) {
        StringBuilder builder = new StringBuilder();
        YangNode inputNode = DataModelUtils.findRpcInput(node);
        if (inputNode != null) {
            String inputName = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(inputNode.getJavaClassNameOrBuiltInType(), null));
            builder.append("        ").append(inputName).append(" ").append(VAR_INPUT_OBJECT).append(" ").append("=").append(" ").append(VAR_MODEL_CONVERTER).append(".").append("createModel").append("(").append(VAR_RPC_INPUT).append(".").append(VAR_INPUT).append("(").append(")").append(")").append(";").append("\n");
        }
        return builder.toString();
    }

    private static String invokeCreateDataNodeString(YangNode node) {
        StringBuilder builder = new StringBuilder();
        YangNode outputNode = DataModelUtils.findRpcOutput(node);
        if (outputNode != null) {
            String outputName = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(outputNode.getJavaClassNameOrBuiltInType(), null));
            builder.append("        ").append("DataNode").append(" ").append(VAR_DATA_NODE).append(" ").append("=").append(" ").append(VAR_MODEL_CONVERTER).append(".").append("createDataNode").append("(").append("(").append("Default").append(outputName).append(")").append(" ").append(VAR_OUTPUT_OBJECT).append(")").append(";").append("\n");
        }
        return builder.toString();
    }

    private static String invokeRpcString(YangNode node, String appService) {
        StringBuilder builder = new StringBuilder();
        String rpc = YangIoUtils.getCamelCase(node.getJavaClassNameOrBuiltInType(), null);
        YangNode inputNode = DataModelUtils.findRpcInput(node);
        YangNode outputNode = DataModelUtils.findRpcOutput(node);
        String outputName = null;
        if (outputNode != null) {
            outputName = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(outputNode.getJavaClassNameOrBuiltInType(), null));
        }
        if (inputNode != null && outputNode != null) {
            builder.append("        ").append(outputName).append(" ").append(VAR_OUTPUT_OBJECT).append(" ").append("=").append(" ").append(appService).append(".").append(rpc).append("(").append(VAR_INPUT_OBJECT).append(")").append(";").append("\n");
        } else if (inputNode != null && outputNode == null) {
            builder.append("        ").append(appService).append(".").append(rpc).append("(").append(VAR_INPUT_OBJECT).append(")").append(";").append("\n");
        } else if (inputNode == null && outputNode != null) {
            builder.append("        ").append(outputName).append(" ").append(VAR_OUTPUT_OBJECT).append(" ").append("=").append(" ").append(appService).append(".").append(rpc).append("(").append(")").append(";").append("\n");
        } else {
            builder.append("        ").append(appService).append(".").append(rpc).append("(").append(")").append(";").append("\n");
        }
        return builder.toString();
    }

    private static String createRpcOutputString(YangNode node) {
        YangNode outputNode = DataModelUtils.findRpcOutput(node);
        String dataNode = VAR_DATA_NODE;
        if (outputNode == null) {
            dataNode = "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("        ").append("RpcOutput").append(" ").append(VAR_OUTPUT).append(" ").append("=").append(" ").append("new").append(" ").append("RpcOutput").append("(").append("RPC_SUCCESS").append(",").append(" ").append(dataNode).append(")").append(";").append("\n");
        return builder.toString();
    }

    private static String invokeRpcResponseString() {
        StringBuilder builder = new StringBuilder();
        builder.append("        ").append(VAR_STORE_SERVICE).append(".").append(RPC_RESPONSE).append("(").append(VAR_MSG_ID).append(",").append(" ").append(VAR_OUTPUT).append(")").append(";").append("\n");
        return builder.toString();
    }
}

