/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangBit;
import org.onosproject.yang.compiler.datamodel.YangBits;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangEnum;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangTranslatorOperatorNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeHolder;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaAttributeInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yang.compiler.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaAugmentTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaEnumerationTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaInputTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaModuleTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaOutputTranslator;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaSubModuleTranslator;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorErrorType;
import org.onosproject.yang.compiler.translator.tojava.utils.TranslatorUtils;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangJavaModelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YangJavaModelUtils.class);

    private YangJavaModelUtils() {
    }

    public static void updatePackageInfo(JavaCodeGeneratorInfo info, YangPluginConfig config) {
        JavaFileInfoTranslator translator = info.getJavaFileInfo();
        if (info instanceof YangJavaAugmentTranslator) {
            YangJavaModelUtils.updatePackageForAugmentInfo(info, config);
        } else {
            YangJavaModelUtils.setNodeJavaName(info, config);
            translator.setJavaAttributeName(info.getJavaFileInfo().getJavaName());
            translator.setPackage(YangJavaModelUtils.getCurNodePackage((YangNode)((Object)info)));
        }
        YangJavaModelUtils.updateCommonPackageInfo(translator, info, config);
    }

    private static void setNodeJavaName(JavaCodeGeneratorInfo info, YangPluginConfig config) {
        String javaGenName = info instanceof YangJavaInputTranslator ? ((YangJavaInputTranslator)info).getParent().getName() + "_input" : (info instanceof YangJavaOutputTranslator ? ((YangJavaOutputTranslator)info).getParent().getName() + "_output" : ((YangNode)((Object)info)).getName());
        info.getJavaFileInfo().setJavaName(YangIoUtils.getCamelCase(javaGenName, config.getConflictResolver()));
    }

    private static void updatePackageForAugmentInfo(JavaCodeGeneratorInfo info, YangPluginConfig config) {
        JavaFileInfoTranslator translator = info.getJavaFileInfo();
        translator.setJavaName(YangJavaModelUtils.getAugmentClassName((YangJavaAugmentTranslator)info, config));
        translator.setPackage(YangJavaModelUtils.getAugmentsNodePackage((YangNode)((Object)info)));
        YangJavaModelUtils.updateCommonPackageInfo(translator, info, config);
    }

    private static String getAugmentsNodePackage(YangNode yangNode) {
        YangAugment augment = (YangAugment)yangNode;
        StringBuilder augmentPkg = new StringBuilder();
        augmentPkg.append(YangJavaModelUtils.getCurNodePackage(augment)).append(".").append(YangJavaModelUtils.getPkgFromAugment(augment));
        return augmentPkg.toString();
    }

    private static String getPkgFromAugment(YangAugment augment) {
        StringBuilder pkg = new StringBuilder();
        for (YangAtomicPath atomicPath : augment.getTargetNode()) {
            pkg.append(YangIoUtils.getCamelCase(atomicPath.getNodeIdentifier().getName(), null)).append(".");
        }
        return YangIoUtils.trimAtLast(pkg.toString(), ".").toLowerCase();
    }

    private static void updatePackageInfo(JavaCodeGeneratorInfo info, YangPluginConfig config, String pkg) {
        JavaFileInfoTranslator translator = info.getJavaFileInfo();
        translator.setJavaName(YangIoUtils.getCamelCase(((YangNode)((Object)info)).getName(), config.getConflictResolver()));
        translator.setPackage(pkg);
        YangJavaModelUtils.updateCommonPackageInfo(translator, info, config);
    }

    private static void updateCommonPackageInfo(JavaFileInfoTranslator translator, JavaCodeGeneratorInfo info, YangPluginConfig config) {
        translator.setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(info.getJavaFileInfo().getPackage()));
        translator.setBaseCodeGenPath(config.getCodeGenDir());
        translator.setPluginConfig(config);
    }

    private static void createTempFragmentFile(JavaCodeGeneratorInfo info) throws IOException {
        info.setTempJavaCodeFragmentFiles(new TempJavaCodeFragmentFiles(info.getJavaFileInfo()));
    }

    private static void updateTempFragmentFiles(JavaCodeGeneratorInfo info, YangPluginConfig config) throws IOException {
        TempJavaCodeFragmentFiles translator = info.getTempJavaCodeFragmentFiles();
        TempJavaBeanFragmentFiles bean = TranslatorUtils.getBeanFiles(info);
        if (info instanceof RpcNotificationContainer) {
            bean.setRootNode(true);
            YangJavaModelUtils.updateNotificationNodeInfo(info, config);
        }
        if (info instanceof YangLeavesHolder) {
            boolean isLeafListPresent;
            YangLeavesHolder holder = (YangLeavesHolder)((Object)info);
            boolean isLeafPresent = holder.getListOfLeaf() != null && !holder.getListOfLeaf().isEmpty();
            boolean bl = isLeafListPresent = holder.getListOfLeafList() != null && !holder.getListOfLeafList().isEmpty();
            if (isLeafPresent || isLeafListPresent) {
                bean.addCurNodeLeavesInfoToTempFiles((YangNode)((Object)info), config);
                bean.addValueLeafFlag(config, (YangNode)((Object)info));
            }
        } else if (info instanceof YangTypeHolder) {
            translator.addTypeInfoToTempFiles((YangTypeHolder)((Object)info), config);
        } else if (info instanceof YangJavaEnumerationTranslator) {
            translator.getEnumTempFiles().addEnumAttributeToTempFiles((YangNode)((Object)info), config);
        } else if (!(info instanceof YangChoice) && !(info instanceof YangRpc)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsgForCodeGenerator(TranslatorErrorType.INVALID_TRANSLATION_NODE, info));
        }
    }

    private static void generateTempFiles(JavaCodeGeneratorInfo info, YangPluginConfig config) throws IOException {
        if (!(info instanceof YangNode)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsgForCodeGenerator(TranslatorErrorType.INVALID_TRANSLATION_NODE, info));
        }
        YangJavaModelUtils.createTempFragmentFile(info);
        YangJavaModelUtils.updateTempFragmentFiles(info, config);
    }

    private static void updateNotificationNodeInfo(JavaCodeGeneratorInfo info, YangPluginConfig config) throws IOException {
        TempJavaCodeFragmentFiles tempFile = info.getTempJavaCodeFragmentFiles();
        for (YangNode notification : ((RpcNotificationContainer)((Object)info)).getNotificationNodes()) {
            tempFile.getEventFragmentFiles().addJavaSnippetOfEvent(notification, config);
        }
    }

    public static void generateCodeAndUpdateInParent(JavaCodeGeneratorInfo info, YangPluginConfig config, boolean isMultiInstance) throws IOException {
        if (!(info instanceof YangNode)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsgForCodeGenerator(TranslatorErrorType.INVALID_TRANSLATION_NODE, info));
        }
        YangNode n = (YangNode)((Object)info);
        if (n.getReferredSchema() != null && !(((YangNode)n.getReferredSchema()).getParent() instanceof YangGrouping)) {
            return;
        }
        YangSchemaNode rn = YangJavaModelUtils.getRefSchema(info);
        if (rn != null) {
            YangNode parent = ((YangNode)((Object)info)).getParent();
            if (!(parent instanceof YangGrouping)) {
                TempJavaFragmentFiles.addCurNodeInfoInParentTempFile((YangNode)rn, isMultiInstance, config, parent);
            }
            return;
        }
        YangJavaModelUtils.generateCodeOfAugmentableNode(info, config);
        TempJavaFragmentFiles.addCurNodeInfoInParentTempFile((YangNode)((Object)info), isMultiInstance, config);
    }

    private static YangSchemaNode getRefSchema(JavaCodeGeneratorInfo info) {
        YangSchemaNode node = (YangSchemaNode)((Object)info);
        if (node.getReferredSchema() == null) {
            return null;
        }
        while (node.getReferredSchema() != null) {
            node = node.getReferredSchema();
        }
        return node;
    }

    public static void generateCodeOfAugmentableNode(JavaCodeGeneratorInfo info, YangPluginConfig config) throws IOException {
        if (!(info instanceof YangNode)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsgForCodeGenerator(TranslatorErrorType.INVALID_TRANSLATION_NODE, info));
        }
        YangJavaModelUtils.generateCodeOfNode(info, config);
        TempJavaBeanFragmentFiles tempFiles = TranslatorUtils.getBeanFiles(info);
        if (info instanceof YangCase) {
            YangNode parent = ((YangCase)((Object)info)).getParent();
            JavaQualifiedTypeInfoTranslator typeInfo = YangJavaModelUtils.getQualifierInfoForCasesParent(parent, config);
            tempFiles.getJavaExtendsListHolder().addToExtendsList(typeInfo, (YangNode)((Object)info), tempFiles);
            tempFiles.addParentInfoInCurNodeTempFile((YangNode)((Object)info), config);
        }
    }

    private static JavaQualifiedTypeInfoTranslator getQualifierInfoForCasesParent(YangNode parent, YangPluginConfig config) {
        String parentPkg;
        String parentName;
        JavaFileInfoTranslator parentInfo;
        if (parent instanceof YangChoice) {
            parentInfo = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo();
        } else {
            parent = ((YangAugment)parent).getAugmentedNode();
            parentInfo = ((JavaFileInfoContainer)((Object)parent)).getJavaFileInfo();
        }
        if (parentInfo.getPackage() != null) {
            parentName = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            parentPkg = parentInfo.getPackage();
        } else {
            parentName = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(parent.getName(), config.getConflictResolver()));
            parentPkg = YangJavaModelUtils.getNodesPackage(parent, config);
        }
        JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = new JavaQualifiedTypeInfoTranslator();
        qualifiedTypeInfo.setClassInfo(parentName);
        qualifiedTypeInfo.setPkgInfo(parentPkg);
        return qualifiedTypeInfo;
    }

    public static void generateCodeOfNode(JavaCodeGeneratorInfo info, YangPluginConfig config) throws IOException {
        if (!(info instanceof YangNode)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsgForCodeGenerator(TranslatorErrorType.INVALID_TRANSLATION_NODE, info));
        }
        YangJavaModelUtils.updatePackageInfo(info, config);
        YangJavaModelUtils.generateTempFiles(info, config);
    }

    public static void generateCodeOfRootNode(JavaCodeGeneratorInfo info, YangPluginConfig config, String rootPkg) throws IOException {
        if (!(info instanceof YangNode)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsgForCodeGenerator(TranslatorErrorType.INVALID_TRANSLATION_NODE, info));
        }
        YangJavaModelUtils.updatePackageInfo(info, config, rootPkg);
        if (DataModelUtils.isRpcNotificationPresent((YangNode)((Object)info))) {
            info.getJavaFileInfo().addGeneratedFileTypes(16);
        }
        YangJavaModelUtils.generateTempFiles(info, config);
    }

    public static String getCurNodePackage(YangNode curNode) throws TranslatorException {
        if (!(curNode instanceof JavaFileInfoContainer) || curNode.getParent() == null) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_NODE, curNode));
        }
        YangNode parentNode = DataModelUtils.getParentNodeInGenCode(curNode);
        if (!(parentNode instanceof JavaFileInfoContainer)) {
            throw new TranslatorException(TranslatorUtils.getErrorMsg(TranslatorErrorType.INVALID_PARENT_NODE, curNode));
        }
        JavaFileInfoTranslator handle = ((JavaFileInfoContainer)((Object)parentNode)).getJavaFileInfo();
        String pkg = handle.getPackage() + "." + handle.getJavaName();
        return pkg.toLowerCase();
    }

    public static boolean isRootNodesCodeGenRequired(YangNode node) {
        return YangJavaModelUtils.isNodeCodeGenRequired(node, true);
    }

    private static boolean isNodeCodeGenRequired(YangNode node, boolean rootNodeGen) {
        YangLeavesHolder holder = (YangLeavesHolder)((Object)node);
        if (!holder.getListOfLeaf().isEmpty()) {
            return true;
        }
        if (!holder.getListOfLeafList().isEmpty()) {
            return true;
        }
        if ((node = node.getChild()) == null) {
            return false;
        }
        if (rootNodeGen) {
            while (node != null) {
                if (!(node instanceof YangTranslatorOperatorNode)) {
                    return true;
                }
                node = node.getNextSibling();
            }
            return false;
        }
        while (node != null) {
            if (!(node instanceof YangAugment)) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    public static String getNodesPackage(YangNode node, YangPluginConfig config) {
        ArrayList<String> clsInfo = new ArrayList<String>();
        while (node.getParent() != null) {
            if (node instanceof YangJavaAugmentTranslator) {
                YangJavaAugmentTranslator augment = (YangJavaAugmentTranslator)node;
                clsInfo.add(YangJavaModelUtils.getAugmentClassName(augment, config));
                clsInfo.add(YangJavaModelUtils.getPkgFromAugment(augment));
            } else {
                clsInfo.add(YangIoUtils.getCamelCase(node.getName(), config.getConflictResolver()));
            }
            node = node.getParent();
        }
        StringBuilder pkg = new StringBuilder();
        if (node instanceof YangJavaModuleTranslator) {
            YangJavaModuleTranslator module = (YangJavaModuleTranslator)node;
            pkg.append(JavaIdentifierSyntax.getRootPackage(module.getVersion(), module.getModuleNamespace(), module.getRevision(), config.getConflictResolver()));
        } else if (node instanceof YangJavaSubModuleTranslator) {
            YangJavaSubModuleTranslator subModule = (YangJavaSubModuleTranslator)node;
            pkg.append(JavaIdentifierSyntax.getRootPackage(subModule.getVersion(), subModule.getNameSpaceFromModule(), subModule.getRevision(), config.getConflictResolver()));
        }
        clsInfo.add(YangIoUtils.getCamelCase(node.getName(), config.getConflictResolver()));
        int size = clsInfo.size();
        for (int i = size - 1; i > 0; --i) {
            pkg.append(".").append((String)clsInfo.get(i));
        }
        return pkg.toString().toLowerCase();
    }

    private static String getAugmentClassName(YangAugment augment, YangPluginConfig config) {
        YangNodeIdentifier identifier = augment.getTargetNode().get(augment.getTargetNode().size() - 1).getNodeIdentifier();
        String prefix = identifier.getPrefix();
        String idName = identifier.getName();
        StringBuilder name = new StringBuilder("Augmented").append("-");
        if (identifier.getPrefix() != null) {
            name.append(prefix).append("-");
        }
        name.append(idName);
        return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(name.toString(), config.getConflictResolver()));
    }

    public static void generateJava(int type, YangNode node) throws IOException {
        if (node.getReferredSchema() == null) {
            ((TempJavaCodeFragmentFilesContainer)((Object)node)).getTempJavaCodeFragmentFiles().generateJavaFile(type, node);
        }
    }

    private static void createAndAddEnum(String name, int value, YangEnumeration enumeration) {
        YangEnum yangEnum = new YangEnum();
        yangEnum.setNamedValue(name);
        yangEnum.setValue(value);
        try {
            enumeration.addEnumInfo(yangEnum);
        }
        catch (DataModelException e) {
            LOG.error("failed to add enum in bits enum class " + e);
        }
    }

    static void generateBitsFile(final JavaAttributeInfo attr, YangType type, JavaFileInfoTranslator fileInfo, TempJavaFragmentFiles tempFile) throws IOException {
        final String className = attr.getAttributeName();
        JavaFileInfoTranslator attrInfo = new JavaFileInfoTranslator();
        attrInfo.setJavaName(className);
        attrInfo.setPackage((fileInfo.getPackage() + "." + fileInfo.getJavaName()).toLowerCase());
        attrInfo.setBaseCodeGenPath(fileInfo.getBaseCodeGenPath());
        attrInfo.setGeneratedFileTypes(32);
        attrInfo.setPackageFilePath(fileInfo.getPackageFilePath() + File.separator + fileInfo.getJavaName().toLowerCase());
        attrInfo.setPluginConfig(fileInfo.getPluginConfig());
        TempJavaCodeFragmentFiles codeFile = new TempJavaCodeFragmentFiles(attrInfo);
        YangJavaEnumerationTranslator enumeration = new YangJavaEnumerationTranslator(){

            @Override
            public String getJavaPackage() {
                return attr.getImportInfo().getPkgInfo();
            }

            @Override
            public String getJavaClassNameOrBuiltInType() {
                return className;
            }

            @Override
            public String getJavaAttributeName() {
                return className;
            }
        };
        enumeration.setName(YangIoUtils.getCapitalCase(className));
        enumeration.setJavaFileInfo(attrInfo);
        enumeration.setTempJavaCodeFragmentFiles(codeFile);
        YangBits yangBits = (YangBits)type.getDataTypeExtendedInfo();
        for (Map.Entry<Integer, YangBit> entry : yangBits.getBitPositionMap().entrySet()) {
            Integer key = entry.getKey();
            YangBit bit = entry.getValue();
            if (bit == null) continue;
            String bitName = bit.getBitName();
            YangJavaModelUtils.createAndAddEnum(bitName, key, enumeration);
        }
        codeFile.getEnumTempFiles().addEnumAttributeToTempFiles(enumeration, fileInfo.getPluginConfig());
        codeFile.getEnumTempFiles().setEnumClass(false);
        codeFile.generateJavaFile(32, enumeration);
        JavaQualifiedTypeInfoTranslator info = new JavaQualifiedTypeInfoTranslator();
        info.setClassInfo(YangIoUtils.getCapitalCase(attrInfo.getJavaName()));
        info.setPkgInfo(attrInfo.getPackage());
        if (tempFile instanceof TempJavaTypeFragmentFiles) {
            tempFile.getJavaImportData().addImportInfo(info, fileInfo.getJavaName(), fileInfo.getPackage());
        }
    }

    public static void generateInterfaceFileForNonDataNodes(YangNode rootNode) throws IOException {
        JavaCodeGeneratorInfo info = (JavaCodeGeneratorInfo)((Object)rootNode);
        TempJavaCodeFragmentFiles tempFile = info.getTempJavaCodeFragmentFiles();
        JavaFileInfoTranslator fileInfo = info.getJavaFileInfo();
        File filePath = new File(fileInfo.getBaseCodeGenPath() + fileInfo.getPackageFilePath());
        String name = YangIoUtils.getCapitalCase(fileInfo.getJavaName());
        YangIoUtils.addPackageInfo(filePath, name, fileInfo.getPackage(), false);
        File interFace = tempFile.getBeanTempFiles().getJavaFileHandle(name);
        YangIoUtils.validateLineLength(JavaFileGenerator.generateInterfaceFile(interFace, null, rootNode, false));
        YangIoUtils.insertDataIntoJavaFile(interFace, "}");
    }
}

