/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;

public class DefaultResourceData
implements ResourceData {
    private List<DataNode> nodes;
    private ResourceId resourceId;

    protected DefaultResourceData(Builder b) {
        this.resourceId = b.resourceId;
        this.nodes = b.nodes;
    }

    public List<DataNode> dataNodes() {
        return this.nodes;
    }

    public ResourceId resourceId() {
        return this.resourceId;
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.nodes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultResourceData) {
            DefaultResourceData that = (DefaultResourceData)obj;
            return Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.nodes, that.nodes);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("resourceId", (Object)this.resourceId).add("nodes", this.nodes).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ResourceData.Builder {
        private List<DataNode> nodes = new LinkedList<DataNode>();
        private ResourceId resourceId;

        protected Builder() {
        }

        public ResourceData.Builder addDataNode(DataNode node) {
            this.nodes.add(node);
            return this;
        }

        public ResourceData.Builder resourceId(ResourceId id) {
            this.resourceId = id;
            return this;
        }

        public ResourceData build() {
            return new DefaultResourceData(this);
        }
    }
}

