/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.http.example.com.schema.yangautoprefix1.yangautoprefix2.config.attributes.top;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.http.example.com.schema.yangautoprefix1.yangautoprefix2.config.attributes.top
            .yangautoprefixinterface.Address;

/**
 * Abstraction of an entity which represents the functionality of yangAutoPrefixInterface.
 */
public interface YangAutoPrefixInterface {

    /**
     * Identify the leaf of YangAutoPrefixInterface.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents mtu.
         */
        MTU(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute mtu.
     *
     * @return mtu value of mtu
     */
    String mtu();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute address.
     *
     * @return address value of address
     */
    Address address();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute mtu.
     *
     * @param mtu value of mtu
     */
    void mtu(String mtu);

    /**
     * Sets the attribute address.
     *
     * @param address value of address
     */
    void address(Address address);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
