/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modelobjecttest.check;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont53.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont53 extends InnerModelObject implements Cont53 {
    protected String leaf55;
    protected List<String> leaf54;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String leaf55() {
        return leaf55;
    }

    @Override
    public List<String> leaf54() {
        return leaf54;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf55(String leaf55) {
        valueLeafFlags.set(LeafIdentifier.LEAF55.getLeafIndex());
        this.leaf55 = leaf55;
    }

    @Override
    public void leaf54(List<String> leaf54) {
        valueLeafFlags.set(LeafIdentifier.LEAF54.getLeafIndex());
        this.leaf54 = leaf54;
    }

    @Override
    public void addToLeaf54(String addTo) {
        if (leaf54 == null) {
            leaf54 = new ArrayList<>();
        }
        leaf54.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf55, leaf54, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont53) {
            DefaultCont53 other = (DefaultCont53) obj;
            return
                Objects.equals(leaf55, other.leaf55) &&
                Objects.equals(leaf54, other.leaf54) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf55=" + leaf55)
            .add("leaf54=" + leaf54)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCont53.
     */
    public DefaultCont53() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
