/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modelobjecttest.check;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of list56.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultList56 extends InnerModelObject 
        implements List56, MultiInstanceObject<List56Keys> {
    protected String leaf58;
    protected List<String> leaf57;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String leaf58() {
        return leaf58;
    }

    @Override
    public List<String> leaf57() {
        return leaf57;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf58(String leaf58) {
        valueLeafFlags.set(LeafIdentifier.LEAF58.getLeafIndex());
        this.leaf58 = leaf58;
    }

    @Override
    public void leaf57(List<String> leaf57) {
        valueLeafFlags.set(LeafIdentifier.LEAF57.getLeafIndex());
        this.leaf57 = leaf57;
    }

    @Override
    public void addToLeaf57(String addTo) {
        if (leaf57 == null) {
            leaf57 = new ArrayList<>();
        }
        leaf57.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf58, leaf57, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultList56) {
            DefaultList56 other = (DefaultList56) obj;
            return
                Objects.equals(leaf58, other.leaf58) &&
                Objects.equals(leaf57, other.leaf57) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf58=" + leaf58)
            .add("leaf57=" + leaf57)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultList56.
     */
    public DefaultList56() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
