/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modelobjecttest.check.list56;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modelobjecttest.check.list56.augmentedlist56.Cont56;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedList56.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedList56 extends InnerModelObject implements AugmentedList56 {
    protected Cont56 cont56;

    @Override
    public Cont56 cont56() {
        return cont56;
    }

    @Override
    public void cont56(Cont56 cont56) {
        this.cont56 = cont56;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cont56);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedList56) {
            DefaultAugmentedList56 other = (DefaultAugmentedList56) obj;
            return
                Objects.equals(cont56, other.cont56);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cont56=" + cont56)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedList56.
     */
    public DefaultAugmentedList56() {
    }

}
