/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.samplenamespace;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.samplenamespace.sample.L1;
import org.onosproject.yang.gen.v1.samplenamespace.sample.L2;
import org.onosproject.yang.gen.v1.samplenamespace.sample.Top;

/**
 * Abstraction of an entity which represents the functionality of sample.
 */
public interface Sample {

    /**
     * Identify the leaf of Sample.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf5.
         */
        LEAF5(1),
        /**
         * Represents leaf6.
         */
        LEAF6(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf5.
     *
     * @return leaf5 value of leaf5
     */
    String leaf5();

    /**
     * Returns the attribute leaf6.
     *
     * @return leaf6 list of leaf6
     */
    List<String> leaf6();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute top.
     *
     * @return top value of top
     */
    Top top();

    /**
     * Returns the attribute l1.
     *
     * @return l1 list of l1
     */
    List<L1> l1();

    /**
     * Returns the attribute l2.
     *
     * @return l2 list of l2
     */
    List<L2> l2();

    /**
     * Sets the attribute leaf5.
     *
     * @param leaf5 value of leaf5
     */
    void leaf5(String leaf5);

    /**
     * Sets the attribute leaf6.
     *
     * @param leaf6 list of leaf6
     */
    void leaf6(List<String> leaf6);

    /**
     * Sets the attribute top.
     *
     * @param top value of top
     */
    void top(Top top);

    /**
     * Sets the attribute l1.
     *
     * @param l1 list of l1
     */
    void l1(List<L1> l1);

    /**
     * Sets the attribute l2.
     *
     * @param l2 list of l2
     */
    void l2(List<L2> l2);

    /**
     * Adds to the list of leaf6.
     *
     * @param addTo value of leaf6
     */
    void addToLeaf6(String addTo);

    /**
     * Adds to the list of l1.
     *
     * @param addTo value of l1
     */
    void addToL1(L1 addTo);

    /**
     * Adds to the list of l2.
     *
     * @param addTo value of l2
     */
    void addToL2(L2 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
