/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.samplenamespace.sample;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of l2.
 */
public class L2Keys implements KeyInfo<DefaultL2> {
    protected String k1;
    /**
     * Returns the attribute k1.
     *
     * @return k1 value of k1
     */
    public String k1() {
        return k1;
    }

    /**
     * Sets the value to attribute k1.
     *
     * @param k1 value of k1
     */
    public void k1(String k1) {
        this.k1 = k1;
    }


    @Override
    public int hashCode() {
        return Objects.hash(k1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof L2Keys) {
            L2Keys other = (L2Keys) obj;
            return
                Objects.equals(k1, other.k1);
        }
        return false;
    }
}