/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simple.data.types.ll.rev20131112.simpledatatypesll.cont1;

import org.onosproject.yang.gen.v1.simple.data.types.ll.rev20131112.simpledatatypesll.cont1.lfunion14union
            .Lfunion14UnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion14Union.
 */
public final class Lfunion14Union {
    private Lfunion14UnionEnum1 enumeration;
    private int uint16;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion14Union.
     */
    private Lfunion14Union() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public Lfunion14Union(Lfunion14UnionEnum1 enumeration) {
        setValue.set(0);
        this.enumeration = enumeration;
    }

    /**
     * Creates an instance of uint16.
     *
     * @param uint16 value of uint16
     */
    public Lfunion14Union(int uint16) {
        setValue.set(1);
        this.uint16 = uint16;
    }

    /**
     * Returns the object of lfunion14Union for type enumeration.
     *
     * @param value value of lfunion14Union for type enumeration
     * @return lfunion14Union for type enumeration
     */
    public static Lfunion14Union of(Lfunion14UnionEnum1 value) {
        return new Lfunion14Union(value);
    }

    /**
     * Returns the object of lfunion14Union for type uint16.
     *
     * @param value value of lfunion14Union for type uint16
     * @return lfunion14Union for type uint16
     */
    public static Lfunion14Union of(int value) {
        return new Lfunion14Union(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public Lfunion14UnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Returns the attribute uint16.
     *
     * @return uint16 value of uint16
     */
    public int uint16() {
        return uint16;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(Lfunion14UnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }
    /**
     * Sets the attribute uint16.
     *
     * @param uint16 value of uint16
     */
    public void uint16(int uint16) {
        this.uint16 = uint16;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration, uint16);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion14Union) {
            Lfunion14Union other = (Lfunion14Union) obj;
            return
                Objects.equals(enumeration, other.enumeration) &&
                Objects.equals(uint16, other.uint16);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return enumeration.toString();
        }
        if (setValue.get(1)) {
            return String.valueOf(uint16);
        }
        return null;
    }
    /**
     * Returns the object of lfunion14Union fromString input String lfunion14Union.
     *
     * @param valInString value of input String
     * @return lfunion14Union
     */
    public static Lfunion14Union fromString(String valInString) {
        try {
            Lfunion14UnionEnum1 tmpVal = Lfunion14UnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
