/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simple.data.types.ll.rev20131112.simpledatatypesll.cont1;

import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion9Union.
 */
public final class Lfunion9Union {
    private int uint16;
    private boolean yangAutoPrefixBoolean;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion9Union.
     */
    private Lfunion9Union() {
    }

    /**
     * Creates an instance of uint16.
     *
     * @param uint16 value of uint16
     */
    public Lfunion9Union(int uint16) {
        setValue.set(0);
        this.uint16 = uint16;
    }

    /**
     * Creates an instance of yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public Lfunion9Union(boolean yangAutoPrefixBoolean) {
        setValue.set(1);
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    /**
     * Returns the object of lfunion9Union for type uint16.
     *
     * @param value value of lfunion9Union for type uint16
     * @return lfunion9Union for type uint16
     */
    public static Lfunion9Union of(int value) {
        return new Lfunion9Union(value);
    }

    /**
     * Returns the object of lfunion9Union for type yangAutoPrefixBoolean.
     *
     * @param value value of lfunion9Union for type yangAutoPrefixBoolean
     * @return lfunion9Union for type yangAutoPrefixBoolean
     */
    public static Lfunion9Union of(boolean value) {
        return new Lfunion9Union(value);
    }

    /**
     * Returns the attribute uint16.
     *
     * @return uint16 value of uint16
     */
    public int uint16() {
        return uint16;
    }
    /**
     * Returns the attribute yangAutoPrefixBoolean.
     *
     * @return yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public boolean yangAutoPrefixBoolean() {
        return yangAutoPrefixBoolean;
    }
    /**
     * Sets the attribute uint16.
     *
     * @param uint16 value of uint16
     */
    public void uint16(int uint16) {
        this.uint16 = uint16;
    }
    /**
     * Sets the attribute yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean value of yangAutoPrefixBoolean
     */
    public void yangAutoPrefixBoolean(boolean yangAutoPrefixBoolean) {
        this.yangAutoPrefixBoolean = yangAutoPrefixBoolean;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint16, yangAutoPrefixBoolean);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion9Union) {
            Lfunion9Union other = (Lfunion9Union) obj;
            return
                Objects.equals(uint16, other.uint16) &&
                Objects.equals(yangAutoPrefixBoolean, other.yangAutoPrefixBoolean);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint16);
        }
        if (setValue.get(1)) {
            return yangAutoPrefixBoolean ? "true" : "false";
        }
        return null;
    }
    /**
     * Returns the object of lfunion9Union fromString input String lfunion9Union.
     *
     * @param valInString value of input String
     * @return lfunion9Union
     */
    public static Lfunion9Union fromString(String valInString) {
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            boolean tmpVal = Boolean.parseBoolean(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
