/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simple.data.types.rev20131112.simpledatatypes;

import org.onosproject.yang.gen.v1.simple.data.types.rev20131112.simpledatatypes.tpdfun0.Tpdfun0Enum;
import java.util.Objects;

/**
 * Represents the implementation of tpdfun0.
 */
public final class Tpdfun0 {

    private Tpdfun0Enum enumeration;

    /**
     * Creates an instance of tpdfun0.
     */
    private Tpdfun0() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public Tpdfun0(Tpdfun0Enum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of tpdfun0 for type enumeration.
     *
     * @param value value of tpdfun0 for type enumeration
     * @return tpdfun0 for type enumeration
     */
    public static Tpdfun0 of(Tpdfun0Enum value) {
        return new Tpdfun0(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public Tpdfun0Enum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(Tpdfun0Enum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tpdfun0) {
            Tpdfun0 other = (Tpdfun0) obj;
            return
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of tpdfun0 fromString input String tpdfun0.
     *
     * @param valInString value of input String
     * @return tpdfun0
     */
    public static Tpdfun0 fromString(String valInString) {
        try {
            Tpdfun0Enum tmpVal = Tpdfun0Enum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
