/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simple.data.types.rev20131112.simpledatatypes.tpdfun0;

/**
 * Represents ENUM data of tpdfun0Enum.
 */
public enum Tpdfun0Enum {

    /**
     * Represents successful exit.
     */
    SUCCESSFUL_EXIT(1, "successful exit"),

    /**
     * Represents grace period expired.
     */
    GRACE_PERIOD_EXPIRED(2, "grace period expired");

    private int tpdfun0Enum;
    private String schemaName;

    /**
     * Creates an instance of tpdfun0Enum.
     *
     * @param tpdfun0Enum value of tpdfun0Enum
     */
     Tpdfun0Enum(int tpdfun0Enum, String schemaName) {
        this.tpdfun0Enum = tpdfun0Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of tpdfun0Enum for.
     *
     * @param value value of tpdfun0Enum for
     * @return tpdfun0Enum for
     */
    public static Tpdfun0Enum of(int value) {
        switch (value) {
            case 1:
                return Tpdfun0Enum.SUCCESSFUL_EXIT;
            case 2:
                return Tpdfun0Enum.GRACE_PERIOD_EXPIRED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of tpdfun0Enum for.
     *
     * @param value value of tpdfun0Enum for
     * @return tpdfun0Enum for
     */
    public static Tpdfun0Enum of(String value) {
        switch (value) {
            case "successful exit":
                return Tpdfun0Enum.SUCCESSFUL_EXIT;
            case "grace period expired":
                return Tpdfun0Enum.GRACE_PERIOD_EXPIRED;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute tpdfun0Enum.
     *
     * @return tpdfun0Enum value of tpdfun0Enum
     */
    public int tpdfun0Enum() {
        return tpdfun0Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
