/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.L3VpnSvc;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ietfL3VpnSvc.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class IetfL3VpnSvcOpParam extends InnerModelObject implements IetfL3VpnSvc {
    protected L3VpnSvc l3VpnSvc;

    @Override
    public L3VpnSvc l3VpnSvc() {
        return l3VpnSvc;
    }

    @Override
    public void l3VpnSvc(L3VpnSvc l3VpnSvc) {
        this.l3VpnSvc = l3VpnSvc;
    }

    @Override
    public int hashCode() {
        return Objects.hash(l3VpnSvc);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IetfL3VpnSvcOpParam) {
            IetfL3VpnSvcOpParam other = (IetfL3VpnSvcOpParam) obj;
            return
                Objects.equals(l3VpnSvc, other.l3VpnSvc);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("l3VpnSvc=" + l3VpnSvc)
            .toString();
    }

    /**
     * Creates an instance of ietfL3VpnSvcOpParam.
     */
    public IetfL3VpnSvcOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}
