/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of bidirTreeType.
 */
public abstract class BidirTreeType extends MulticastTreeType {

    /**
     * Returns the attribute bidir-tree-type.
     *
     * @return bidir-tree-type value of bidir-tree-type
     */
    public static String bidirTreeTypeToString() {
        return "bidir-tree-type";
    }

    /**
     * Returns the object of bidirTreeType fromString input String bidirTreeType.
     *
     * @param valInString value of input String
     * @return bidirTreeType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bidir-tree-type")) {
            return BidirTreeType.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}