/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.l3vpnsvc
            .Sites;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.l3vpnsvc
            .VpnServices;

/**
 * Abstraction of an entity which represents the functionality of l3VpnSvc.
 */
public interface L3VpnSvc {

    /**
     * Returns the attribute vpnServices.
     *
     * @return vpnServices value of vpnServices
     */
    VpnServices vpnServices();

    /**
     * Returns the attribute sites.
     *
     * @return sites value of sites
     */
    Sites sites();

    /**
     * Sets the attribute vpnServices.
     *
     * @param vpnServices value of vpnServices
     */
    void vpnServices(VpnServices vpnServices);

    /**
     * Sets the attribute sites.
     *
     * @param sites value of sites
     */
    void sites(Sites sites);

}
