/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessdiversity;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessdiversity.accessdiversity.Constraints;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessdiversity.accessdiversity.Groups;

/**
 * Abstraction of an entity which represents the functionality of accessDiversity.
 */
public interface AccessDiversity {

    /**
     * Returns the attribute groups.
     *
     * @return groups value of groups
     */
    Groups groups();

    /**
     * Returns the attribute constraints.
     *
     * @return constraints value of constraints
     */
    Constraints constraints();

    /**
     * Sets the attribute groups.
     *
     * @param groups value of groups
     */
    void groups(Groups groups);

    /**
     * Sets the attribute constraints.
     *
     * @param constraints value of constraints
     */
    void constraints(Constraints constraints);

}
