/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessdiversity.accessdiversity.constraints;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .PlacementDiversity;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessdiversity.accessdiversity.constraints.constraint.Target;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of constraint.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConstraint extends InnerModelObject 
        implements Constraint, MultiInstanceObject<ConstraintKeys> {
    protected Class<? extends PlacementDiversity> constraintType;
    protected BitSet valueLeafFlags = new BitSet();
    protected Target target;

    @Override
    public Class<? extends PlacementDiversity> constraintType() {
        return constraintType;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Target target() {
        return target;
    }

    @Override
    public void constraintType(Class<? extends PlacementDiversity> constraintType) {
        valueLeafFlags.set(LeafIdentifier.CONSTRAINTTYPE.getLeafIndex());
        this.constraintType = constraintType;
    }

    @Override
    public void target(Target target) {
        this.target = target;
    }

    @Override
    public int hashCode() {
        return Objects.hash(constraintType, valueLeafFlags, target);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConstraint) {
            DefaultConstraint other = (DefaultConstraint) obj;
            return
                Objects.equals(constraintType, other.constraintType) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(target, other.target);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("constraintType=" + constraintType)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("target=" + target)
            .toString();
    }


    /**
     * Creates an instance of defaultConstraint.
     */
    public DefaultConstraint() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
