/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .customerlocationinfo;

import java.util.BitSet;

/**
 * Abstraction of an entity which represents the functionality of location.
 */
public interface Location {

    /**
     * Identify the leaf of Location.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents address.
         */
        ADDRESS(1),
        /**
         * Represents zipCode.
         */
        ZIPCODE(2),
        /**
         * Represents state.
         */
        STATE(3),
        /**
         * Represents city.
         */
        CITY(4),
        /**
         * Represents countryCode.
         */
        COUNTRYCODE(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute address.
     *
     * @return address value of address
     */
    String address();

    /**
     * Returns the attribute zipCode.
     *
     * @return zipCode value of zipCode
     */
    String zipCode();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    String state();

    /**
     * Returns the attribute city.
     *
     * @return city value of city
     */
    String city();

    /**
     * Returns the attribute countryCode.
     *
     * @return countryCode value of countryCode
     */
    String countryCode();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute address.
     *
     * @param address value of address
     */
    void address(String address);

    /**
     * Sets the attribute zipCode.
     *
     * @param zipCode value of zipCode
     */
    void zipCode(String zipCode);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(String state);

    /**
     * Sets the attribute city.
     *
     * @param city value of city
     */
    void city(String city);

    /**
     * Sets the attribute countryCode.
     *
     * @param countryCode value of countryCode
     */
    void countryCode(String countryCode);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
