/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .flowdefinition.matchflow;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.ProtocolType;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of protocolFieldUnion.
 */
public final class ProtocolFieldUnion {
    private short uint8;
    private Class<? extends ProtocolType> identityref;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of protocolFieldUnion.
     */
    private ProtocolFieldUnion() {
    }

    /**
     * Creates an instance of uint8.
     *
     * @param uint8 value of uint8
     */
    public ProtocolFieldUnion(short uint8) {
        setValue.set(0);
        this.uint8 = uint8;
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public ProtocolFieldUnion(Class<? extends ProtocolType> identityref) {
        setValue.set(1);
        this.identityref = identityref;
    }

    /**
     * Returns the object of protocolFieldUnion for type uint8.
     *
     * @param value value of protocolFieldUnion for type uint8
     * @return protocolFieldUnion for type uint8
     */
    public static ProtocolFieldUnion of(short value) {
        return new ProtocolFieldUnion(value);
    }

    /**
     * Returns the object of protocolFieldUnion for type identityref.
     *
     * @param value value of protocolFieldUnion for type identityref
     * @return protocolFieldUnion for type identityref
     */
    public static ProtocolFieldUnion of(Class<? extends ProtocolType> value) {
        return new ProtocolFieldUnion(value);
    }

    /**
     * Returns the attribute uint8.
     *
     * @return uint8 value of uint8
     */
    public short uint8() {
        return uint8;
    }
    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends ProtocolType> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute uint8.
     *
     * @param uint8 value of uint8
     */
    public void uint8(short uint8) {
        this.uint8 = uint8;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends ProtocolType> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint8, identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProtocolFieldUnion) {
            ProtocolFieldUnion other = (ProtocolFieldUnion) obj;
            return
                Objects.equals(uint8, other.uint8) &&
                Objects.equals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint8);
        }
        if (setValue.get(1)) {
            return ProtocolType.protocolTypeToString();
        }
        return null;
    }
    /**
     * Returns the object of protocolFieldUnion fromString input String protocolFieldUnion.
     *
     * @param valInString value of input String
     * @return protocolFieldUnion
     */
    public static ProtocolFieldUnion fromString(String valInString) {
        try {
            short tmpVal = Short.parseShort(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Class<? extends ProtocolType> tmpVal = ProtocolType.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
