/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.l3vpnsvc
            .sites.site.sitenetworkaccesses;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .SiteNetworkAccessType;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessdiversity.AccessDiversity;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .accessvpnpolicy.VpnAttachment;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentavailability.Availability;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentbearer.Bearer;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.IpConnection;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .RoutingProtocols;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.sitesecurity
            .Security;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siteservice
            .Service;

/**
 * Abstraction of an entity which represents the functionality of siteNetworkAccess.
 */
public interface SiteNetworkAccess {

    /**
     * Identify the leaf of SiteNetworkAccess.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents siteNetworkAccessId.
         */
        SITENETWORKACCESSID(1),
        /**
         * Represents siteNetworkAccessType.
         */
        SITENETWORKACCESSTYPE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute siteNetworkAccessId.
     *
     * @return siteNetworkAccessId value of siteNetworkAccessId
     */
    SvcId siteNetworkAccessId();

    /**
     * Returns the attribute siteNetworkAccessType.
     *
     * @return siteNetworkAccessType value of siteNetworkAccessType
     */
    Class<? extends SiteNetworkAccessType> siteNetworkAccessType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute accessDiversity.
     *
     * @return accessDiversity value of accessDiversity
     */
    AccessDiversity accessDiversity();

    /**
     * Returns the attribute bearer.
     *
     * @return bearer value of bearer
     */
    Bearer bearer();

    /**
     * Returns the attribute ipConnection.
     *
     * @return ipConnection value of ipConnection
     */
    IpConnection ipConnection();

    /**
     * Returns the attribute security.
     *
     * @return security value of security
     */
    Security security();

    /**
     * Returns the attribute service.
     *
     * @return service value of service
     */
    Service service();

    /**
     * Returns the attribute routingProtocols.
     *
     * @return routingProtocols value of routingProtocols
     */
    RoutingProtocols routingProtocols();

    /**
     * Returns the attribute availability.
     *
     * @return availability value of availability
     */
    Availability availability();

    /**
     * Returns the attribute vpnAttachment.
     *
     * @return vpnAttachment value of vpnAttachment
     */
    VpnAttachment vpnAttachment();

    /**
     * Sets the attribute siteNetworkAccessId.
     *
     * @param siteNetworkAccessId value of siteNetworkAccessId
     */
    void siteNetworkAccessId(SvcId siteNetworkAccessId);

    /**
     * Sets the attribute siteNetworkAccessType.
     *
     * @param siteNetworkAccessType value of siteNetworkAccessType
     */
    void siteNetworkAccessType(Class<? extends SiteNetworkAccessType> siteNetworkAccessType);

    /**
     * Sets the attribute accessDiversity.
     *
     * @param accessDiversity value of accessDiversity
     */
    void accessDiversity(AccessDiversity accessDiversity);

    /**
     * Sets the attribute bearer.
     *
     * @param bearer value of bearer
     */
    void bearer(Bearer bearer);

    /**
     * Sets the attribute ipConnection.
     *
     * @param ipConnection value of ipConnection
     */
    void ipConnection(IpConnection ipConnection);

    /**
     * Sets the attribute security.
     *
     * @param security value of security
     */
    void security(Security security);

    /**
     * Sets the attribute service.
     *
     * @param service value of service
     */
    void service(Service service);

    /**
     * Sets the attribute routingProtocols.
     *
     * @param routingProtocols value of routingProtocols
     */
    void routingProtocols(RoutingProtocols routingProtocols);

    /**
     * Sets the attribute availability.
     *
     * @param availability value of availability
     */
    void availability(Availability availability);

    /**
     * Sets the attribute vpnAttachment.
     *
     * @param vpnAttachment value of vpnAttachment
     */
    void vpnAttachment(VpnAttachment vpnAttachment);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
