/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .multicastrpgroupcfg.groupformat;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .multicastrpgroupcfg.GroupFormat;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715.yrtietfinettypes
            .IpAddress;

/**
 * Abstraction of an entity which represents the functionality of startend.
 */
public interface Startend extends GroupFormat  {

    /**
     * Identify the leaf of Startend.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents groupStart.
         */
        GROUPSTART(1),
        /**
         * Represents groupEnd.
         */
        GROUPEND(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute groupStart.
     *
     * @return groupStart value of groupStart
     */
    IpAddress groupStart();

    /**
     * Returns the attribute groupEnd.
     *
     * @return groupEnd value of groupEnd
     */
    IpAddress groupEnd();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute groupStart.
     *
     * @param groupStart value of groupStart
     */
    void groupStart(IpAddress groupStart);

    /**
     * Sets the attribute groupEnd.
     *
     * @param groupEnd value of groupEnd
     */
    void groupEnd(IpAddress groupEnd);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
