/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentbearer;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentbearer.bearer.RequestedType;

/**
 * Abstraction of an entity which represents the functionality of bearer.
 */
public interface Bearer {

    /**
     * Identify the leaf of Bearer.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents alwaysOn.
         */
        ALWAYSON(1),
        /**
         * Represents bearerReference.
         */
        BEARERREFERENCE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute alwaysOn.
     *
     * @return alwaysOn value of alwaysOn
     */
    boolean alwaysOn();

    /**
     * Returns the attribute bearerReference.
     *
     * @return bearerReference value of bearerReference
     */
    String bearerReference();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute requestedType.
     *
     * @return requestedType value of requestedType
     */
    RequestedType requestedType();

    /**
     * Sets the attribute alwaysOn.
     *
     * @param alwaysOn value of alwaysOn
     */
    void alwaysOn(boolean alwaysOn);

    /**
     * Sets the attribute bearerReference.
     *
     * @param bearerReference value of bearerReference
     */
    void bearerReference(String bearerReference);

    /**
     * Sets the attribute requestedType.
     *
     * @param requestedType value of requestedType
     */
    void requestedType(RequestedType requestedType);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
