/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.Ipv4;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.Ipv6;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.Oam;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ipConnection.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpConnection extends InnerModelObject implements IpConnection {
    protected Ipv4 ipv4;
    protected Ipv6 ipv6;
    protected Oam oam;

    @Override
    public Ipv4 ipv4() {
        return ipv4;
    }

    @Override
    public Ipv6 ipv6() {
        return ipv6;
    }

    @Override
    public Oam oam() {
        return oam;
    }

    @Override
    public void ipv4(Ipv4 ipv4) {
        this.ipv4 = ipv4;
    }

    @Override
    public void ipv6(Ipv6 ipv6) {
        this.ipv6 = ipv6;
    }

    @Override
    public void oam(Oam oam) {
        this.oam = oam;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipv4, ipv6, oam);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpConnection) {
            DefaultIpConnection other = (DefaultIpConnection) obj;
            return
                Objects.equals(ipv4, other.ipv4) &&
                Objects.equals(ipv6, other.ipv6) &&
                Objects.equals(oam, other.oam);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ipv4=" + ipv4)
            .add("ipv6=" + ipv6)
            .add("oam=" + oam)
            .toString();
    }


    /**
     * Creates an instance of defaultIpConnection.
     */
    public DefaultIpConnection() {
    }

}
