/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.Ipv4;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.Ipv6;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.Oam;

/**
 * Abstraction of an entity which represents the functionality of ipConnection.
 */
public interface IpConnection {

    /**
     * Returns the attribute ipv4.
     *
     * @return ipv4 value of ipv4
     */
    Ipv4 ipv4();

    /**
     * Returns the attribute ipv6.
     *
     * @return ipv6 value of ipv6
     */
    Ipv6 ipv6();

    /**
     * Returns the attribute oam.
     *
     * @return oam value of oam
     */
    Oam oam();

    /**
     * Sets the attribute ipv4.
     *
     * @param ipv4 value of ipv4
     */
    void ipv4(Ipv4 ipv4);

    /**
     * Sets the attribute ipv6.
     *
     * @param ipv6 value of ipv6
     */
    void ipv6(Ipv6 ipv6);

    /**
     * Sets the attribute oam.
     *
     * @param oam value of oam
     */
    void oam(Oam oam);

}
