/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .AddressAllocationType;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteattachmentipconnection.ipconnection.ipv4.Addresses;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ipv4.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpv4 extends InnerModelObject implements Ipv4 {
    protected Class<? extends AddressAllocationType> addressAllocationType;
    protected short numberOfDynamicAddress;
    protected BitSet valueLeafFlags = new BitSet();
    protected Addresses addresses;

    @Override
    public Class<? extends AddressAllocationType> addressAllocationType() {
        return addressAllocationType;
    }

    @Override
    public short numberOfDynamicAddress() {
        return numberOfDynamicAddress;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Addresses addresses() {
        return addresses;
    }

    @Override
    public void addressAllocationType(Class<? extends AddressAllocationType> addressAllocationType) {
        valueLeafFlags.set(LeafIdentifier.ADDRESSALLOCATIONTYPE.getLeafIndex());
        this.addressAllocationType = addressAllocationType;
    }

    @Override
    public void numberOfDynamicAddress(short numberOfDynamicAddress) {
        valueLeafFlags.set(LeafIdentifier.NUMBEROFDYNAMICADDRESS.getLeafIndex());
        this.numberOfDynamicAddress = numberOfDynamicAddress;
    }

    @Override
    public void addresses(Addresses addresses) {
        this.addresses = addresses;
    }

    @Override
    public int hashCode() {
        return Objects.hash(addressAllocationType, numberOfDynamicAddress, valueLeafFlags, addresses);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv4) {
            DefaultIpv4 other = (DefaultIpv4) obj;
            return
                Objects.equals(addressAllocationType, other.addressAllocationType) &&
                Objects.equals(numberOfDynamicAddress, other.numberOfDynamicAddress) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(addresses, other.addresses);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("addressAllocationType=" + addressAllocationType)
            .add("numberOfDynamicAddress=" + numberOfDynamicAddress)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("addresses=" + addresses)
            .toString();
    }


    /**
     * Creates an instance of defaultIpv4.
     */
    public DefaultIpv4() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
