/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .sitemaximumroutes;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .sitemaximumroutes.maximumroutes.AddressFamily;

/**
 * Abstraction of an entity which represents the functionality of maximumRoutes.
 */
public interface MaximumRoutes {

    /**
     * Returns the attribute addressFamily.
     *
     * @return addressFamily list of addressFamily
     */
    List<AddressFamily> addressFamily();

    /**
     * Sets the attribute addressFamily.
     *
     * @param addressFamily list of addressFamily
     */
    void addressFamily(List<AddressFamily> addressFamily);

    /**
     * Adds to the list of addressFamily.
     *
     * @param addTo value of addressFamily
     */
    void addToAddressFamily(AddressFamily addTo);

}
