/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .sitemaximumroutes.maximumroutes;

import java.util.BitSet;

/**
 * Abstraction of an entity which represents the functionality of addressFamily.
 */
public interface AddressFamily {

    /**
     * Identify the leaf of AddressFamily.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents af.
         */
        AF(1),
        /**
         * Represents maximumRoutes.
         */
        MAXIMUMROUTES(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute af.
     *
     * @return af value of af
     */
    Class<? extends org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .AddressFamily> af();

    /**
     * Returns the attribute maximumRoutes.
     *
     * @return maximumRoutes value of maximumRoutes
     */
    long maximumRoutes();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute af.
     *
     * @param af value of af
     */
    void af(Class<? extends org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730
            .ietfl3vpnsvc.AddressFamily> af);

    /**
     * Sets the attribute maximumRoutes.
     *
     * @param maximumRoutes value of maximumRoutes
     */
    void maximumRoutes(long maximumRoutes);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
