/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .routingprotocols;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .RoutingProtocolType;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .routingprotocols.routingprotocol.Bgp;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .routingprotocols.routingprotocol.Ospf;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .routingprotocols.routingprotocol.Rip;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .routingprotocols.routingprotocol.Vrrp;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.siterouting
            .routingprotocols.routingprotocol.YangAutoPrefixStatic;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of routingProtocol.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRoutingProtocol extends InnerModelObject 
        implements RoutingProtocol, MultiInstanceObject<RoutingProtocolKeys> {
    protected Class<? extends RoutingProtocolType> type;
    protected BitSet valueLeafFlags = new BitSet();
    protected Ospf ospf;
    protected Bgp bgp;
    protected YangAutoPrefixStatic yangAutoPrefixStatic;
    protected Rip rip;
    protected Vrrp vrrp;

    @Override
    public Class<? extends RoutingProtocolType> type() {
        return type;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Ospf ospf() {
        return ospf;
    }

    @Override
    public Bgp bgp() {
        return bgp;
    }

    @Override
    public YangAutoPrefixStatic yangAutoPrefixStatic() {
        return yangAutoPrefixStatic;
    }

    @Override
    public Rip rip() {
        return rip;
    }

    @Override
    public Vrrp vrrp() {
        return vrrp;
    }

    @Override
    public void type(Class<? extends RoutingProtocolType> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void ospf(Ospf ospf) {
        this.ospf = ospf;
    }

    @Override
    public void bgp(Bgp bgp) {
        this.bgp = bgp;
    }

    @Override
    public void yangAutoPrefixStatic(YangAutoPrefixStatic yangAutoPrefixStatic) {
        this.yangAutoPrefixStatic = yangAutoPrefixStatic;
    }

    @Override
    public void rip(Rip rip) {
        this.rip = rip;
    }

    @Override
    public void vrrp(Vrrp vrrp) {
        this.vrrp = vrrp;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, valueLeafFlags, ospf, bgp, yangAutoPrefixStatic, rip, vrrp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRoutingProtocol) {
            DefaultRoutingProtocol other = (DefaultRoutingProtocol) obj;
            return
                Objects.equals(type, other.type) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(ospf, other.ospf) &&
                Objects.equals(bgp, other.bgp) &&
                Objects.equals(yangAutoPrefixStatic, other.yangAutoPrefixStatic) &&
                Objects.equals(rip, other.rip) &&
                Objects.equals(vrrp, other.vrrp);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("type=" + type)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("ospf=" + ospf)
            .add("bgp=" + bgp)
            .add("yangAutoPrefixStatic=" + yangAutoPrefixStatic)
            .add("rip=" + rip)
            .add("vrrp=" + vrrp)
            .toString();
    }


    /**
     * Creates an instance of defaultRoutingProtocol.
     */
    public DefaultRoutingProtocol() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
