/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteserviceqosprofile.qos;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteserviceqosprofile.qos.qosclassificationpolicy.Rule;

/**
 * Abstraction of an entity which represents the functionality of qosClassificationPolicy.
 */
public interface QosClassificationPolicy {

    /**
     * Returns the attribute rule.
     *
     * @return rule list of rule
     */
    List<Rule> rule();

    /**
     * Sets the attribute rule.
     *
     * @param rule list of rule
     */
    void rule(List<Rule> rule);

    /**
     * Adds to the list of rule.
     *
     * @param addTo value of rule
     */
    void addToRule(Rule addTo);

}
