/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteserviceqosprofile.qos.qosclassificationpolicy;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteserviceqosprofile.qos.qosclassificationpolicy.rule.MatchType;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of rule.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRule extends InnerModelObject 
        implements Rule, MultiInstanceObject<RuleKeys> {
    protected int id;
    protected String targetClassId;
    protected BitSet valueLeafFlags = new BitSet();
    protected MatchType matchType;

    @Override
    public int id() {
        return id;
    }

    @Override
    public String targetClassId() {
        return targetClassId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public MatchType matchType() {
        return matchType;
    }

    @Override
    public void id(int id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void targetClassId(String targetClassId) {
        valueLeafFlags.set(LeafIdentifier.TARGETCLASSID.getLeafIndex());
        this.targetClassId = targetClassId;
    }

    @Override
    public void matchType(MatchType matchType) {
        this.matchType = matchType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, targetClassId, valueLeafFlags, matchType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRule) {
            DefaultRule other = (DefaultRule) obj;
            return
                Objects.equals(id, other.id) &&
                Objects.equals(targetClassId, other.targetClassId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(matchType, other.matchType);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("targetClassId=" + targetClassId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("matchType=" + matchType)
            .toString();
    }


    /**
     * Creates an instance of defaultRule.
     */
    public DefaultRule() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
