/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteserviceqosprofile.qos.qosprofile.qosprofile.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .siteserviceqosprofile.qos.qosprofile.qosprofile.custom.classes.YangAutoPrefixClass;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of classes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultClasses extends InnerModelObject implements Classes {
    protected List<YangAutoPrefixClass> yangAutoPrefixClass;

    @Override
    public List<YangAutoPrefixClass> yangAutoPrefixClass() {
        return yangAutoPrefixClass;
    }

    @Override
    public void yangAutoPrefixClass(List<YangAutoPrefixClass> yangAutoPrefixClass) {
        this.yangAutoPrefixClass = yangAutoPrefixClass;
    }

    @Override
    public void addToYangAutoPrefixClass(YangAutoPrefixClass addTo) {
        if (yangAutoPrefixClass == null) {
            yangAutoPrefixClass = new ArrayList<>();
        }
        yangAutoPrefixClass.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixClass);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultClasses) {
            DefaultClasses other = (DefaultClasses) obj;
            return
                Objects.equals(yangAutoPrefixClass, other.yangAutoPrefixClass);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixClass=" + yangAutoPrefixClass)
            .toString();
    }


    /**
     * Creates an instance of defaultClasses.
     */
    public DefaultClasses() {
    }

}
