/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.sitevpnpolicy
            .vpnpolicylist.vpnpolicy.entries.filter.lan;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.sitevpnpolicy
            .vpnpolicylist.vpnpolicy.entries.filter.Lan;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.sitevpnpolicy
            .vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.LanPrefixes;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of lanPrefix.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLanPrefix extends InnerModelObject implements LanPrefix {
    protected LanPrefixes lanPrefixes;

    @Override
    public LanPrefixes lanPrefixes() {
        return lanPrefixes;
    }

    @Override
    public void lanPrefixes(LanPrefixes lanPrefixes) {
        this.lanPrefixes = lanPrefixes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(lanPrefixes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLanPrefix) {
            DefaultLanPrefix other = (DefaultLanPrefix) obj;
            return
                Objects.equals(lanPrefixes, other.lanPrefixes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lanPrefixes=" + lanPrefixes)
            .toString();
    }


    /**
     * Creates an instance of defaultLanPrefix.
     */
    public DefaultLanPrefix() {
    }

}
